/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.type;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import io.github.bi0qaw.biosphere.util.Frame;
import io.github.bi0qaw.biosphere.util.VectorMath;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrameType {
    static {
        Classes.registerClass((ClassInfo)new ClassInfo(Frame.class, "frame").user(new String[]{"frames?"}).name("Frame").description(new String[]{"Reference frame that can be used to get vectors relative to some direction."}).usage(new String[]{"frame of %entity%", "frame with yaw %number% and pitch %number%"}).examples(new String[]{"set {_frame} to frame of player", "set {_circle::*} to circle with radius 1 and density 5", "show happy villager at player's head offset by {_circle::*} in frame of player", "#shows a particle circle around the player's head with the yaw and pitch of the player"}).defaultExpression((DefaultExpression)new EventValueExpression(Frame.class)).parser((Parser)new Parser<Frame>(){
            private final Pattern parsePattern = Pattern.compile("frame:(-?\\d+(\\.\\d+)?),(-?\\d+(\\.\\d+)?)", 2);

            public Frame parse(String s, ParseContext parseContext) {
                Matcher m = this.parsePattern.matcher(s);
                if (m.matches()) {
                    float yaw = VectorMath.fromSkriptYaw(Float.parseFloat(m.group(1)));
                    float pitch = VectorMath.fromSkriptPitch(Float.parseFloat(m.group(3)));
                    return new Frame().setFromYawPitch(yaw, pitch);
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND || context == ParseContext.EVENT || context == ParseContext.SCRIPT;
            }

            public String toString(Frame f, int i) {
                float yaw = VectorMath.skriptYaw(f.getYaw());
                float pitch = VectorMath.skriptPitch(f.getPitch());
                return "frame:yaw: " + Skript.toString((double)yaw) + ", pitch: " + Skript.toString((double)pitch);
            }

            public String toVariableNameString(Frame f) {
                float yaw = VectorMath.skriptYaw(f.getYaw());
                float pitch = VectorMath.skriptPitch(f.getPitch());
                return "frame:" + Skript.toString((double)yaw) + "," + Skript.toString((double)pitch);
            }

            public String getVariableNamePattern() {
                return "frame:(-?\\d+(\\.\\d+)?),(-?\\d+(\\.\\d+)?)";
            }

            public String getDebugMessage(Frame f) {
                float yaw = VectorMath.skriptYaw(f.getYaw());
                float pitch = VectorMath.skriptPitch(f.getPitch());
                return "frame:yaw=" + Skript.toString((double)yaw) + ",pitch=" + Skript.toString((double)pitch);
            }
        }).serializer((Serializer)new Serializer<Frame>(){

            public Fields serialize(Frame f) throws NotSerializableException {
                Fields fields = new Fields();
                float yaw = VectorMath.skriptYaw(f.getYaw());
                float pitch = VectorMath.skriptPitch(f.getPitch());
                fields.putPrimitive("yaw", (Object)Float.valueOf(yaw));
                fields.putPrimitive("pitch", (Object)Float.valueOf(pitch));
                return fields;
            }

            public void deserialize(Frame f, Fields fields) throws StreamCorruptedException, NotSerializableException {
                assert (false);
            }

            protected Frame deserialize(Fields f) throws StreamCorruptedException, NotSerializableException {
                float yaw = VectorMath.fromSkriptYaw(((Float)f.getPrimitive("yaw", Float.TYPE)).floatValue());
                float pitch = VectorMath.fromSkriptPitch(((Float)f.getPrimitive("pitch", Float.TYPE)).floatValue());
                return new Frame().setFromYawPitch(yaw, pitch);
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }));
    }
}

