/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Rotate XYZ")
@Description(value={"Rotates vectors around a rotation center and rotation axis by an angle."})
@Examples(value={"set {_point} to vector 1, 2, 3", "set {_point} to {_point} rotated around y-axis at player with angle 180", "#{_point} is now equal to the vector -1, 2, -3"})
public class ExprVectorRotateXYZ
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Number> angle;
    private int axis;
    private static final String[] axisStr = new String[]{"x", "y", "z"};

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.vectors = expr[0];
        this.angle = expr[1];
        this.axis = parseResult.mark;
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return this.vectors.toString(e, arg1) + " rotated around " + axisStr[this.axis] + "-axis with angle " + this.angle.toString(e, arg1);
    }

    @Nullable
    protected Vector[] get(Event e) {
        float a = ((Number)this.angle.getSingle(e)).floatValue();
        a = -a;
        Vector[] clones = VectorLib.clone((Vector[])this.vectors.getArray(e));
        if (this.axis == 1) {
            return VectorLib.rotateX(clones, a);
        }
        if (this.axis == 2) {
            return VectorLib.rotateY(clones, a);
        }
        return VectorLib.rotateZ(clones, a);
    }
}

