/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Path")
@Description(value={"Creates a path between vectors. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_polygon::*} to polygon with 7 points and radius 3", "set {_path::*} to vector path between {_polygon::*} with density 5", "show happy villager at player offset by {_path::*}"})
public class ExprVectorPath
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Number> density;

    protected Vector[] get(Event event) {
        return VectorLib.getPath((Vector[])this.vectors.getArray(event), ((Number)this.density.getSingle(event)).doubleValue());
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return "vector path between " + this.vectors.toString(event, b) + " with density " + this.density.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vectors = expressions[0];
        this.density = expressions[1];
        return true;
    }
}

