/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Midpoint")
@Description(value={"Gives the midpoint between vectors."})
@Examples(value={"set {_circle::*} to circle with radius 1 and density 5", "set {_midpoint} to vector midpoint of {_circle::*}", "#{_midpoint} is a vector pointing to the center of the circle"})
public class ExprVectorMidpoint
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.vectors = expr[0];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "vector midpoint of " + this.vectors.toString(arg0, arg1);
    }

    @Nullable
    protected Vector[] get(Event e) {
        return new Vector[]{VectorLib.midpoint((Vector[])this.vectors.getArray(e))};
    }
}

