/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Helix")
@Description(value={"Creates a list of vectors in the shape of a helix. The step parameter determines how many blocks the helix will go upwards in one rotation. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_helix::*} to helix with radius 2, height 3, step 1 and density 5", "show happy villager at player's head offset by {_helix::*}"})
public class ExprVectorHelix
extends SimpleExpression<Vector> {
    private Expression<Number> radius;
    private Expression<Number> height;
    private Expression<Number> step;
    private Expression<Number> density;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.radius = expr[0];
        this.height = expr[1];
        this.step = expr[2];
        this.density = expr[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "helix with radius " + this.radius.toString(arg0, arg1) + ", height " + this.height.toString(arg0, arg1) + ", step " + this.step.toString(arg0, arg1) + " and density " + this.density.toString(arg0, arg1);
    }

    @Nullable
    protected Vector[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        double h = ((Number)this.height.getSingle(e)).doubleValue();
        double s = ((Number)this.step.getSingle(e)).doubleValue();
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return VectorLib.getHelix(r, h, s, d);
    }
}

