/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Random Sphere")
@Description(value={"Creates a list of locations in the shape of a sphere. The locations are randomly distributed on the sphere surface."})
@Examples(value={"show happy villager at random sphere at player with radius 1 and density 5"})
public class ExprLocationSphereRand
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> radius;
    private Expression<Number> density;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.radius = expr[1];
        this.density = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "random sphere at " + this.locations.toString(arg0, arg1) + " with density " + this.density.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return LocationLib.getRandomSphere((Location[])this.locations.getArray(e), r, d);
    }
}

