/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Location Scale")
@Description(value={"Scales locations from a center by a scaling factor. The direction parameter adds an additional scaling along the x-, y- and z-axis."})
@Examples(value={"set {_circle::*} to circle at player with radius 1 and density 5", "set {_bigcircle::*} to {_circle::*} scaled at player by 2", "#Makes the circle 2 times bigger.", "set {_ellipse::*} to {_circle::*} scaled at player by 1 in direction vector 1, 1, 2", "#Makes the circle 2 times bigger in the z-direction but does not change the x- and y-coordinates. This creates an ellipse.", "show happy villager at {_circle::*}", "show happy villager at {_bigcircle::*}", "show happy villager at {_ellipse::*}"})
public class ExprLocationScale
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Location> center;
    private Expression<Number> factor;
    private Expression<Vector> direction;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.locations = expr[0];
        this.center = expr[1];
        this.factor = expr[2];
        this.direction = expr[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        if (this.direction == null) {
            return this.locations.toString(arg0, arg1) + " scaled with center " + this.center.toString(arg0, arg1) + " by " + this.factor.toString(arg0, arg1);
        }
        return this.locations.toString(arg0, arg1) + " scaled with center " + this.center.toString(arg0, arg1) + " by " + this.factor.toString(arg0, arg1) + " in direction " + this.direction.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double f = ((Number)this.factor.getSingle(e)).doubleValue();
        if (this.direction == null) {
            return LocationLib.scale((Location[])this.locations.getArray(e), (Location)this.center.getSingle(e), f);
        }
        return LocationLib.scaleDirectional((Location[])this.locations.getArray(e), (Location)this.center.getSingle(e), (Vector)this.direction.getSingle(e), f);
    }
}

