/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Location Rotate")
@Description(value={"Rotates locations around a rotation center and a rotation axis by an angle."})
@Examples(value={"set {_point} to location 5 in front of player", "set {_point} to {_point} rotated around vector 0, 1, 0 at player with angle 180", "show happy villager at {_point}", "#shows a particle at the location 5 behind the player", "#vector 0, 1, 0 creates a vector along the y-axis, which is used as the rotation axis"})
public class ExprLocationRotate
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Vector> axis;
    private Expression<Location> center;
    private Expression<Number> angle;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.locations = expr[0];
        this.axis = expr[1];
        this.center = expr[2];
        this.angle = expr[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.locations.toString(arg0, arg1) + " rotated around " + this.axis.toString(arg0, arg1) + " at " + this.center.toString(arg0, arg1) + " with angle " + this.angle.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        float a = ((Number)this.angle.getSingle(e)).floatValue();
        a = -a;
        Vector ax = ((Vector)this.axis.getSingle(e)).clone().normalize();
        return LocationLib.rotate((Location[])this.locations.getArray(e), (Location)this.center.getSingle(e), ax, a);
    }
}

