/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Polygon")
@Description(value={"Creates a list of locations in the shape of a polygon (only the corners!). If you want a polygon with edges use polygon outline."})
@Examples(value={"set {_polygon::*} to polygon at player with 3 points and radius 3", "show happy villager at {_polygon::*}", "#shows particles in the shape of a triangle at the player"})
public class ExprLocationPolygon
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> points;
    private Expression<Number> radius;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.points = expr[1];
        this.radius = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "polygon at " + this.locations.toString(arg0, arg1) + " with " + this.points.toString(arg0, arg1) + " points and radius " + this.radius.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        int p = ((Number)this.points.getSingle(e)).intValue();
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        return LocationLib.getPolygon((Location[])this.locations.getArray(e), p, r);
    }
}

