/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Path")
@Description(value={"Creates a path between the locations. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_polygon::*} to polygon at player with 7 points and radius 3", "set {_path::*} to path between {_polygon::*} with density 5", "show happy villager at {_path::*}"})
public class ExprLocationPath
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> density;

    protected Location[] get(Event event) {
        return LocationLib.getPath((Location[])this.locations.getArray(event), ((Number)this.density.getSingle(event)).doubleValue());
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public String toString(Event event, boolean b) {
        return "path between" + this.locations.toString(event, b) + "with density " + this.density.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.locations = expressions[0];
        this.density = expressions[1];
        return true;
    }
}

