/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Location Move")
@Description(value={"Moves a list of locations from one location to another."})
@Examples(value={"set {_circle::*} to circle at player with radius 1 and density 5", "set {_moved::*} to {_circle::*} with center player moved to location 5 in front of player", "show happy villager at {_moved::*}"})
public class ExprLocationMove
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Location> center;
    private Expression<Location> point;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.center = expr[1];
        this.point = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "move " + this.locations.toString(arg0, arg1) + " with center " + this.center.toString(arg0, arg1) + " to " + this.locations.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        Vector delta = ((Location)this.point.getSingle(e)).toVector().subtract(((Location)this.center.getSingle(e)).toVector());
        return LocationLib.offset((Location[])this.locations.getArray(e), delta);
    }
}

