/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Helix")
@Description(value={"Creates a list of locations in the shape of a helix. The step parameter determines how many blocks the helix will go upwards in one rotation. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"show happy villager at helix at player's head with radius 2, height 3, step 1 and density 5", "#shows a helix at the player's head with a height of 3 blocks that makes a total of 3 rotations"})
public class ExprLocationHelix
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> radius;
    private Expression<Number> height;
    private Expression<Number> step;
    private Expression<Number> density;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.radius = expr[1];
        this.height = expr[2];
        this.step = expr[3];
        this.density = expr[4];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "helix at " + this.locations.toString(arg0, arg1) + " with radius " + this.radius.toString(arg0, arg1) + ", height " + this.height.toString(arg0, arg1) + ", step " + this.step.toString(arg0, arg1) + " and density " + this.density.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        double h = ((Number)this.height.getSingle(e)).doubleValue();
        double s = ((Number)this.step.getSingle(e)).doubleValue();
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return LocationLib.getHelix((Location[])this.locations.getArray(e), r, h, s, d);
    }
}

