/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Cube")
@Description(value={"Creates a list of locations in the shape of a cube (only the corners!). To get a list of locations including the cube edges use cube outline."})
@Examples(value={"show happy villager at cube at player's head with radius 1"})
public class ExprLocationCube
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> radius;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.radius = expr[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "cube at " + this.locations.toString(arg0, arg1) + " with radius " + this.radius.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        return LocationLib.getCube((Location[])this.locations.getArray(e), r);
    }
}

