/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Sphere")
@Description(value={"Creates a list of vectors in the shape of a sphere. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_sphere::*} to sphere with radius 1 and density 5", "show happy villager at player offset by {_sphere::*}"})
public class ExprVectorSphere
extends SimpleExpression<Vector> {
    private Expression<Number> radius;
    private Expression<Number> density;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.radius = expr[0];
        this.density = expr[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "sphere with radius " + this.radius.toString() + " and density " + this.density.toString();
    }

    @Nullable
    protected Vector[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return VectorLib.getSphere(r, d);
    }
}

