/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Scale")
@Description(value={"Scales vectors by a scaling factor and an optional direction. The direction parameter adds an additional scaling along the x-, y- and z-axis."})
@Examples(value={"set {_circle::*} to circle with radius 1 and density 5", "set {_bigcircle::*} to {_circle::*} scaled by 2", "#Makes the circle 2 times bigger.", "set {_ellipse::*} to {_circle::*} scaled by 1 in direction vector 1, 1, 2", "#Makes the circle 2 times bigger in the z-direction but does not change the x- and y-coordinates. This creates an ellipse.", "show happy villager at player offset by {_circle::*}", "show happy villager at player offset by {_bigcircle::*}", "show happy villager at player offset by {_ellipse::*}"})
public class ExprVectorScale
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Number> factor;
    private Expression<Vector> direction;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.vectors = expr[0];
        this.factor = expr[1];
        this.direction = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.vectors.toString() + " scaled by " + this.factor.toString() + " in direction " + this.direction.toString();
    }

    @Nullable
    protected Vector[] get(Event e) {
        double f = ((Number)this.factor.getSingle(e)).doubleValue();
        if (this.direction == null) {
            return VectorLib.scale((Vector[])((Vector[])this.vectors.getArray(e)).clone(), f);
        }
        return VectorLib.scaleDirectional((Vector[])((Vector[])this.vectors.getArray(e)).clone(), (Vector)this.direction.getSingle(e), f);
    }
}

