/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Rotate")
@Description(value={"Rotates vectors around a rotation center and a rotation axis by an angle."})
@Examples(value={"set {_point} to vector 1, 2, 3", "set {_point} to {_point} rotated around vector 0, 1, 0 at player with angle 180", "#{_point} is now equal to the vector -1, 2, -3", "#vector 0, 1, 0 creates a vector along the y-axis, which is used as the rotation axis"})
public class ExprVectorRotate
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Vector> axis;
    private Expression<Number> angle;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.vectors = expr[0];
        this.axis = expr[1];
        this.angle = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.vectors.toString(arg0, arg1) + " rotated around " + this.axis.toString(arg0, arg1) + " with angle " + this.angle.toString(arg0, arg1);
    }

    @Nullable
    protected Vector[] get(Event e) {
        float a = ((Number)this.angle.getSingle(e)).floatValue();
        a = -a;
        Vector ax = ((Vector)this.axis.getSingle(e)).clone().normalize();
        return VectorLib.rotate((Vector[])((Vector[])this.vectors.getArray(e)).clone(), ax, a);
    }
}

