/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Reflection")
@Description(value={"Mirrors vectors in another vector. The direction parameter applies an additional scaling for each axis."})
@Examples(value={"set {_point} to vector 1, 2, 3 mirrored at vector 0, 0, 0", "#{_point} is now equal to the vector -1, -2, -3"})
public class ExprVectorReflection
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Vector> center;
    private Expression<Vector> direction;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.vectors = expr[0];
        this.center = expr[1];
        this.direction = expr[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return this.vectors.toString() + " mirrored at " + this.center.toString() + " in direction " + this.direction.toString();
    }

    @Nullable
    protected Vector[] get(Event e) {
        if (this.direction == null) {
            return VectorLib.pointReflection((Vector[])((Vector[])this.vectors.getArray(e)).clone(), (Vector)this.center.getSingle(e));
        }
        return VectorLib.reflection((Vector[])((Vector[])this.vectors.getArray(e)).clone(), (Vector)this.center.getSingle(e), (Vector)this.direction.getSingle(e));
    }
}

