/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Polygon Outline")
@Description(value={"Creates a list of vectors in the shape of a polygon including corners and edges. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_polyoutline::*} to polygon outline with 6 points, radius 3 and density 5", "show happy villager at player offset by {_polygonoutline::*}", "#shows particles in the shape of a hexagon (6 points) at the player"})
public class ExprVectorPolygonOutline
extends SimpleExpression<Vector> {
    private Expression<Integer> vertices;
    private Expression<Number> radius;
    private Expression<Number> density;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.vertices = expr[0];
        this.radius = expr[1];
        this.density = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "polygon outline with " + this.vertices.toString(arg0, arg1) + " vertices, radius " + this.radius.toString(arg0, arg1) + " and density " + this.density.toString(arg0, arg1);
    }

    @Nullable
    protected Vector[] get(Event e) {
        int v = (Integer)this.vertices.getSingle(e);
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return VectorLib.getPolygonOutline(v, r, d);
    }
}

