/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Polygon")
@Description(value={"Creates a list of vectors in the shape of a polygon (only the corners!). If you want a polygon with edges use polygon outline."})
@Examples(value={"set {_polygon::*} to polygon with 3 points and radius 3", "show happy villager at player offset by {_polygon::*}", "#shows particles in the shape of a triangle at the player"})
public class ExprVectorPolygon
extends SimpleExpression<Vector> {
    private Expression<Integer> vertices;
    private Expression<Number> radius;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.vertices = expr[0];
        this.radius = expr[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "vector polygon with " + this.vertices.toString() + " vertices and radius " + this.radius.toString();
    }

    @Nullable
    protected Vector[] get(Event e) {
        int p = (Integer)this.vertices.getSingle(e);
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        return VectorLib.getPolygon(p, r);
    }
}

