/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Offset")
@Description(value={"Offset vectors by other vectors."})
@Examples(value={"set {_circle::*} to circle with radius 1 and density 5", "set {_offset::*} to {_circle::*} offset by vector 1, 2, 3", "#Moves the circle from the origin (vector 0, 0, 0) to the position at 1, 2, 3"})
public class ExprVectorMove
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Vector> offset;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.vectors = expr[0];
        this.offset = expr[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.vectors.toString() + " moved by " + this.offset.toString();
    }

    @Nullable
    protected Vector[] get(Event e) {
        Vector[] o = (Vector[])this.offset.getAll(e);
        Vector totalOffset = new Vector();
        for (Vector v : o) {
            totalOffset.add(v);
        }
        return VectorLib.offset((Vector[])((Vector[])this.vectors.getArray(e)).clone(), totalOffset);
    }
}

