/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.Frame;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector in Frame")
@Description(value={"Converts a vector in a reference frame to the standard Minecraft coordinates."})
@Examples(value={"set {_vector} to vector 5, 0, 0 in frame of player", "#Gives a vector that points 5 blocks in the player's direction", "set {_circle::*} to circle with radius 1 and density 5 in frame of player", "#Gives a list of vectors in the shape of a circle around the player's head with the correct yaw and pitch"})
public class ExprVectorInFrame
extends SimpleExpression<Vector> {
    private Expression<Vector> vectors;
    private Expression<Frame> frame;

    protected Vector[] get(Event event) {
        Frame f = (Frame)this.frame.getSingle(event);
        Vector[] v = (Vector[])this.vectors.getArray(event);
        Vector[] transformed = new Vector[v.length];
        int i = 0;
        for (Vector vec : v) {
            transformed[i] = f.transform(vec.clone());
            ++i;
        }
        return transformed;
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return this.vectors.toString(event, b) + " in " + this.frame.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vectors = expressions[0];
        this.frame = expressions[1];
        return true;
    }
}

