/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.VectorLib;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Vector Circle")
@Description(value={"Creates a list of vectors in the shape of a circle"})
@Examples(value={"set {_circle::*} to circle with radius 1 and density 5", "show happy villager at player's head offset by {_circle::*}"})
public class ExprVectorCircle
extends SimpleExpression<Vector> {
    private Expression<Number> radius;
    private Expression<Number> density;

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.radius = expr[0];
        this.density = expr[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "circle with radius " + this.radius.toString(arg0, arg1) + " and density " + this.density.toString(arg0, arg1);
    }

    @Nullable
    protected Vector[] get(Event e) {
        int n = (int)(((Number)this.radius.getSingle(e)).doubleValue() * 2.0 * Math.PI * ((Number)this.density.getSingle(e)).doubleValue());
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        return VectorLib.getPolygon(n, r);
    }
}

