/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Link All")
@Description(value={"Creates a list of locations linking multiple locations with lines. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"set {_circle::*} to circle at player with radius 5 and density 0.2", "#gets the points in the shape of a circle around the player", "set {_linked::*} to {_circle::*} linked with density 2", "#connects all points on the circle with lines", "show happy villager at {_linked::*}"})
public class ExprLocationLinkAll
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> density;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.density = expr[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.locations.toString(arg0, arg1) + " linked with density " + this.density.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return LocationLib.linkAll((Location[])this.locations.getArray(e), d);
    }
}

