/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Line Coordinate")
@Description(value={"Gives a location on the line between two locations. The number parameter describes how far the point is from the first location. A value of 0 corresponds the the start (first location). A value of 1 corresponds to the end (location 2). 0.5 is the midpoint between the two locations."})
@Examples(value={"show happy villager at line coordinate 0.2 between player and location 10 in front of player", "#shows a particle 2 blocks in front of the player"})
public class ExprLocationLineLoc
extends SimpleExpression<Location> {
    private Expression<Number> point;
    private Expression<Location> location1;
    private Expression<Location> location2;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return this.location1.isSingle();
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.point = expr[0];
        this.location1 = expr[1];
        this.location2 = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "line coordinate " + this.point.toString(arg0, arg1) + " from " + this.location1.toString(arg0, arg1) + " to " + this.location2.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double p = ((Number)this.point.getSingle(e)).doubleValue();
        return LocationLib.getLineCoordinate((Location[])this.location1.getArray(e), (Location)this.location2.getSingle(e), p);
    }
}

