/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Line")
@Description(value={"Creates a list of locations in the shape of a line. The density value controls the amount of points. A higher number increases the amount of points. A density of 1 corresponds to 1 point per block."})
@Examples(value={"show happy villager at line between player's head and location 5 in front of player's head with density 5"})
public class ExprLocationLine
extends SimpleExpression<Location> {
    private Expression<Location> location1;
    private Expression<Location> location2;
    private Expression<Number> density;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.location1 = expr[0];
        this.location2 = expr[1];
        this.density = expr[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "line from " + this.location1.toString(arg0, arg1) + " to " + this.location2.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double d = ((Number)this.density.getSingle(e)).doubleValue();
        return LocationLib.getLine((Location[])this.location1.getArray(e), (Location)this.location2.getSingle(e), d);
    }
}

