/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.LocationLib;
import io.github.bi0qaw.biosphere.util.VectorMath;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Location Cylinder Coordinate")
@Description(value={"Gives locations in a cylindrical coordinate system."})
@Examples(value={"set {_loc} to cylinder coordinate at player with radius 5, yaw 90 and height 5", "#gives the location 5 blocks in the negative x-direction and 5 blocks above the player"})
public class ExprLocationCylinderLoc
extends SimpleExpression<Location> {
    private Expression<Location> locations;
    private Expression<Number> radius;
    private Expression<Number> yaw;
    private Expression<Number> height;

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.locations = expr[0];
        this.radius = expr[1];
        this.yaw = expr[2];
        this.height = expr[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "cylinder coordinate at " + this.locations.toString(arg0, arg1) + " with radius " + this.radius.toString(arg0, arg1) + ", yaw " + this.yaw.toString(arg0, arg1) + " and height " + this.height.toString(arg0, arg1);
    }

    @Nullable
    protected Location[] get(Event e) {
        double r = ((Number)this.radius.getSingle(e)).doubleValue();
        float y = ((Number)this.yaw.getSingle(e)).floatValue();
        double h = ((Number)this.height.getSingle(e)).doubleValue();
        y = VectorMath.fromSkriptYaw(y);
        y = VectorMath.wrapYaw(y);
        return LocationLib.getCylindricalCoordinate((Location[])this.locations.getArray(e), r, y, h);
    }
}

