/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.biosphere.expression;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.biosphere.util.Frame;
import io.github.bi0qaw.biosphere.util.VectorMath;
import org.bukkit.event.Event;

@Name(value="Frame Yaw and Pitch")
@Description(value={"Yaw and pitch of a frame. Mainly used to rotate or incline reference frames"})
@Examples(value={"set {_frame} to frame from yaw 90 and pitch -45", "set {_yaw} to frame yaw of {_frame} #{_yaw} is now equal to 90", "add 90 to frame yaw of {_frame}", "set {_yaw} to frame yaw of {_frame} #{_yaw} is now equal to 180"})
public class ExprFrameYawPitch
extends SimplePropertyExpression<Frame, Number> {
    private int mark;
    private static final String[] type = new String[]{"yaw", "pitch"};

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        super.init(expressions, i, kleenean, parseResult);
        this.mark = parseResult.mark;
        return true;
    }

    protected String getPropertyName() {
        return "frame " + type[this.mark];
    }

    public Number convert(Frame frame) {
        if (frame != null) {
            switch (this.mark) {
                case 0: {
                    return Float.valueOf(VectorMath.skriptYaw(frame.getYaw()));
                }
                case 1: {
                    return Float.valueOf(VectorMath.skriptPitch(frame.getPitch()));
                }
            }
        }
        return null;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public Class<Frame>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) && this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange((Expression)this.getExpr(), (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Frame.class})) {
            return new Class[]{Number.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Frame f = (Frame)this.getExpr().getSingle(e);
        if (f == null) {
            return;
        }
        float v = ((Number)delta[0]).floatValue();
        float yaw = f.getYaw();
        float pitch = f.getPitch();
        switch (mode) {
            case REMOVE: {
                v = -v;
            }
            case ADD: {
                if (this.mark == 0) {
                    yaw += v;
                } else if (this.mark == 1) {
                    pitch -= v;
                }
                yaw = VectorMath.wrapYaw(yaw);
                pitch = VectorMath.wrapPitch(pitch);
                f = f.setFromYawPitch(yaw, pitch);
                this.getExpr().change(e, (Object[])new Frame[]{f}, Changer.ChangeMode.SET);
                break;
            }
            case SET: {
                if (this.mark == 0) {
                    yaw = VectorMath.wrapYaw(v);
                    yaw = VectorMath.fromSkriptYaw(yaw);
                } else if (this.mark == 1) {
                    pitch = VectorMath.wrapPitch(v);
                    pitch = VectorMath.fromSkriptPitch(pitch);
                }
                f = f.setFromYawPitch(yaw, pitch);
                this.getExpr().change(e, (Object[])new Frame[]{f}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }
}

