/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.bi0qaw;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class TrigLib {
    Number pi = Math.PI;

    public double sin(double d) {
        return Math.sin(d);
    }

    public double cos(double d) {
        return Math.cos(d);
    }

    public double tan(double d) {
        return Math.tan(d);
    }

    public double pow(double d) {
        return Math.pow(d, 2.0);
    }

    public double pow(double d, double v) {
        return Math.pow(d, v);
    }

    public Number[] llen(Location[] l) {
        Number[] nums = new Number[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            nums[i] = tempLoc.clone().toVector().length();
            ++i;
            ++n2;
        }
        return nums;
    }

    public Location[] lneg(Location[] l) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().multiply(-1.0);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] offset(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().add(l2);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] coffset(Location[] l, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().add(x, y, z);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] mult(Location[] l, double p) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().multiply(p);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] lmult(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector loc2 = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().multiply(loc2).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] lnorm(Location[] l) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().normalize().toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] relloc(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(l2);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Number[] dotp(Location[] l, Location l2) {
        Number[] nums = new Number[Array.getLength(l)];
        Vector v2 = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            nums[i] = tempLoc.clone().toVector().dot(v2);
            ++i;
            ++n2;
        }
        return nums;
    }

    public Number[] cdotp(Location[] l, double x, double y, double z) {
        Number[] nums = new Number[Array.getLength(l)];
        Vector v2 = new Vector(x, y, z);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            nums[i] = tempLoc.clone().toVector().dot(v2);
            ++i;
            ++n2;
        }
        return nums;
    }

    public Location[] crossp(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector v2 = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().crossProduct(v2).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] ccrossp(Location[] l, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector v = new Vector(x, y, z);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().crossProduct(v).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] rot(Location[] l, Location center, Location direction, double phi) {
        Location[] locs = new Location[Array.getLength(l)];
        Location lnormValue = this.lnorm(new Location[]{direction})[0];
        double n1 = lnormValue.getX();
        double n2 = lnormValue.getY();
        double n3 = lnormValue.getZ();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n4 = 0;
        while (n4 < n) {
            Location tempLoc = locationArray[n4];
            locs[i] = tempLoc.clone().subtract(center);
            double x = locs[i].getX();
            double y = locs[i].getY();
            double z = locs[i].getZ();
            locs[i].setX(x * (Math.pow(n1, 2.0) * (1.0 - this.cos(phi)) + this.cos(phi)) + y * (n2 * n1 * (1.0 - this.cos(phi)) - n3 * this.sin(phi)) + z * (n1 * n3 * (1.0 - this.cos(phi)) + n2 * this.sin(phi)));
            locs[i].setY(x * (n1 * n2 * (1.0 - this.cos(phi)) + n3 * this.sin(phi)) + y * (this.pow(n2) * (1.0 - this.cos(phi)) + this.cos(phi) + z * (n2 * n3 * (1.0 - this.cos(phi)) - n1 * this.sin(phi))));
            locs[i].setZ(x * (n3 * n1 * (1.0 - this.cos(phi)) - n2 * this.sin(phi)) + y * (n3 * n2 * (1.0 - this.cos(phi)) + n1 * this.sin(phi)) + z * (this.pow(n3) * (1.0 - this.cos(phi)) + this.cos(phi)));
            ++i;
            ++n4;
        }
        return this.offset(locs, center);
    }

    public Location[] xrot(Location[] l, Location center, double phi) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center);
            double y = locs[i].getY();
            double z = locs[i].getZ();
            locs[i].setY(y * Math.cos(phi) + z * Math.sin(phi));
            locs[i].setZ(-y * Math.sin(phi) + z * Math.cos(phi));
            ++i;
            ++n2;
        }
        return this.offset(locs, center);
    }

    public Location[] yrot(Location[] l, Location center, double phi) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center);
            double x = locs[i].getX();
            double z = locs[i].getZ();
            locs[i].setX(x * Math.cos(phi) - z * Math.sin(phi));
            locs[i].setZ(x * Math.sin(phi) + z * Math.cos(phi));
            locs[i].add(center);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] zrot(Location[] l, Location center, double phi) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center);
            double x = locs[i].getX();
            double y = locs[i].getY();
            locs[i].setX(x * Math.cos(phi) + y * Math.sin(phi));
            locs[i].setY(-x * Math.sin(phi) + y * Math.cos(phi));
            ++i;
            ++n2;
        }
        return this.offset(locs, center);
    }

    public Location[] ptrefl(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(l2).multiply(-2.0).add(l2);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] refl(Location[] l, Location point, Location dir) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector pointv = point.clone().toVector();
        Vector dirv = dir.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().multiply(pointv.multiply(dirv)).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] scale(Location[] l, Location center, double d) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center).multiply(d).add(center);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] dirscale(Location[] l, Location center, Location dir, double d) {
        Vector dirv = dir.clone().toVector().normalize().multiply(d);
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center).toVector().multiply(dirv).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] cdirscale(Location[] l, Location center, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center).toVector().multiply(vect).toLocation(tempLoc.getWorld()).add(center);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] midpt(Location[] l) {
        Location loc = new Location(l[0].getWorld(), 0.0, 0.0, 0.0);
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            loc.add(tempLoc);
            ++n2;
        }
        return new Location[]{loc.multiply(1.0 / (double)Array.getLength(l))};
    }

    public Location[] sphloc(Location[] l, double phi, double the, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + r * Math.sin(the) * Math.cos(phi));
            locs[i].setY(tempLoc.getY() + r * Math.cos(the));
            locs[i].setZ(tempLoc.getZ() + r * Math.sin(the) * Math.sin(phi));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] cylloc(Location[] l, double phi, double r, double h) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + r * Math.cos(phi));
            locs[i].setY(tempLoc.getY() + h);
            locs[i].setZ(tempLoc.getZ() + r * Math.sin(phi));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] cubeloc(Location[] l, Location l2, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        double d = r / Math.pow(2.0, 0.5);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + d * (2.0 * l2.getX() - 1.0));
            locs[i].setY(tempLoc.getY() + d * (2.0 * l2.getY() - 1.0));
            locs[i].setZ(tempLoc.getZ() + d * (2.0 * l2.getZ() - 1.0));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] ccubeloc(Location[] l, double x, double y, double z, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        double d = r / Math.pow(2.0, 0.5);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + d * (2.0 * x - 1.0));
            locs[i].setY(tempLoc.getY() + d * (2.0 * y - 1.0));
            locs[i].setZ(tempLoc.getZ() + d * (2.0 * z - 1.0));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] lineloc(Location[] l, Location l2, double p) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().add(l2.clone().subtract(tempLoc).multiply(p));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] getLine(Location[] l, Location l2, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            int k = (int)(tempLoc.distance(l2) * d);
            Location v = l2.clone().subtract(tempLoc).multiply(1.0 / (double)k);
            int i = 0;
            while (i < k) {
                locs.add(tempLoc.clone().add(v.clone().multiply((double)i)));
                ++i;
            }
            ++n2;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] linkAll(Location[] loc, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        Location[] locationArray = loc;
        int n = loc.length;
        int n2 = 0;
        while (n2 < n) {
            Location l1 = locationArray[n2];
            Location[] locationArray2 = loc;
            int n3 = loc.length;
            int n4 = 0;
            while (n4 < n3) {
                Location l2 = locationArray2[n4];
                if (!l1.equals((Object)l2)) {
                    locs.addAll(Arrays.asList(this.getLine(new Location[]{l1}, l2, d)));
                }
                ++n4;
            }
            ++n2;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getPoly(Location[] l, int n, double r) {
        double phi = Math.PI * 2 / (double)n;
        Location[] locs = new Location[n * Array.getLength(l)];
        int i = 0;
        int j = 0;
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            Location loc = tempLoc.clone().add(r, 0.0, 0.0);
            i = 0;
            while (i < n) {
                locs[j] = this.yrot(new Location[]{loc}, tempLoc, (double)i * phi)[0];
                ++j;
                ++i;
            }
            ++n3;
        }
        return locs;
    }

    public Location[] getPolyOutline(Location[] l, Integer n, double r, double d) {
        Location[] loc = new Location[n.intValue()];
        ArrayList<Location> locs = new ArrayList<Location>();
        int i = 0;
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            loc = this.getPoly(new Location[]{tempLoc}, n, r);
            i = 0;
            while (i < n - 1) {
                locs.addAll(Arrays.asList(this.getLine(new Location[]{loc[i]}, loc[i + 1], d)));
                ++i;
            }
            locs.addAll(Arrays.asList(this.getLine(new Location[]{loc[i]}, loc[0], d)));
            ++n3;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getCube(Location[] l, double r) {
        Location[] loc = new Location[4];
        Location[] locs = new Location[8];
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            loc = this.getPoly(new Location[]{tempLoc}, 4, r);
            int i = 0;
            Location[] locationArray2 = loc;
            int n3 = loc.length;
            int n4 = 0;
            while (n4 < n3) {
                Location tempLoc2 = locationArray2[n4];
                double length = loc[0].distance(loc[1]) / 2.0;
                locs[i] = tempLoc2.clone().add(0.0, -length, 0.0);
                locs[++i] = tempLoc2.clone().add(0.0, length, 0.0);
                ++i;
                ++n4;
            }
            ++n2;
        }
        return locs;
    }

    public Location[] getCubeOutline(Location[] l, double r, double d) {
        Location[] cube = new Location[8];
        ArrayList<Location> locs = new ArrayList<Location>();
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            cube = this.getCube(new Location[]{tempLoc}, r);
            locs.addAll(Arrays.asList(cube));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[0]}, cube[1], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[1]}, cube[3], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[4]}, cube[5], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[4]}, cube[6], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[1]}, cube[7], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[6]}, cube[7], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[0]}, cube[6], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[0]}, cube[2], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[4]}, cube[2], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[2]}, cube[3], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[3]}, cube[5], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[5]}, cube[7], d)));
            ++n2;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getSphereRand(Location[] l, double r, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        int n = (int)(Math.PI * 4 * r * r * d);
        double phi = 0.0;
        double the = 0.0;
        Random randGen = new Random();
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            int i = 0;
            while (i < n) {
                phi = randGen.nextDouble() * 2.0 * Math.PI;
                the = randGen.nextDouble() * Math.PI;
                locs.add(this.sphloc(new Location[]{tempLoc}, phi, the, r)[0]);
                ++i;
            }
            ++n3;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getSphere(Location[] l, double r, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        double the = 0.0;
        double phi = 0.0;
        int n = (int)(Math.PI * r * d);
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            the = 0.0;
            int i = 0;
            while (i < n) {
                phi = 0.0;
                int j = 0;
                while (j < n * 2) {
                    locs.add(this.sphloc(new Location[]{tempLoc}, phi, the, r)[0]);
                    phi += Math.PI / (double)n;
                    ++j;
                }
                the += Math.PI / (double)n;
                ++i;
            }
            ++n3;
        }
        return locs.toArray(new Location[locs.size()]);
    }
}

