/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.bi0qaw;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class TrigLib {
    public Number[] llen(Location[] l) {
        Number[] nums = new Number[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            nums[i] = tempLoc.clone().toVector().length();
            ++i;
            ++n2;
        }
        return nums;
    }

    public Location[] lneg(Location[] l) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().multiply(-1.0);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] offset(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().add(vect);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] coffset(Location[] l, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().add(x, y, z);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] mult(Location[] l, double p) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().multiply(p);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] lmult(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().multiply(vect).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] lnorm(Location[] l) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().normalize().toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] relloc(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(vect);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Number[] dotp(Location[] l, Location l2) {
        Number[] nums = new Number[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            nums[i] = tempLoc.clone().toVector().dot(vect);
            ++i;
            ++n2;
        }
        return nums;
    }

    public Number[] cdotp(Location[] l, double x, double y, double z) {
        Number[] nums = new Number[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            nums[i] = tempLoc.clone().toVector().dot(vect);
            ++i;
            ++n2;
        }
        return nums;
    }

    public Location[] crossp(Location[] l, Location l2) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = l2.clone().toVector();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().crossProduct(vect).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] ccrossp(Location[] l, double x, double y, double z) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().crossProduct(vect).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] rot(Location[] l, Location center, Location direction, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        Location lnormValue = this.lnorm(new Location[]{direction})[0];
        double n1 = lnormValue.getX();
        double n2 = lnormValue.getY();
        double n3 = lnormValue.getZ();
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n4 = 0;
        while (n4 < n) {
            Location tempLoc = locationArray[n4];
            locs[i] = tempLoc.clone().subtract(centerVect);
            double x = locs[i].getX();
            double y = locs[i].getY();
            double z = locs[i].getZ();
            locs[i].setX(x * (Math.pow(n1, 2.0) * (1.0 - Math.cos(phi)) + Math.cos(phi)) + y * (n2 * n1 * (1.0 - Math.cos(phi)) - n3 * Math.sin(phi)) + z * (n1 * n3 * (1.0 - Math.cos(phi)) + n2 * Math.sin(phi)));
            locs[i].setY(x * (n1 * n2 * (1.0 - Math.cos(phi)) + n3 * Math.sin(phi)) + y * (Math.pow(n2, 2.0) * (1.0 - Math.cos(phi)) + Math.cos(phi) + z * (n2 * n3 * (1.0 - Math.cos(phi)) - n1 * Math.sin(phi))));
            locs[i].setZ(x * (n3 * n1 * (1.0 - Math.cos(phi)) - n2 * Math.sin(phi)) + y * (n3 * n2 * (1.0 - Math.cos(phi)) + n1 * Math.sin(phi)) + z * (Math.pow(n3, 2.0) * (1.0 - Math.cos(phi)) + Math.cos(phi)));
            ++i;
            ++n4;
        }
        return this.offset(locs, center);
    }

    public Location[] xrot(Location[] l, Location center, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(centerVect);
            double y = locs[i].getY();
            double z = locs[i].getZ();
            locs[i].setY(y * Math.cos(phi) + z * Math.sin(phi));
            locs[i].setZ(-y * Math.sin(phi) + z * Math.cos(phi));
            ++i;
            ++n2;
        }
        return this.offset(locs, center);
    }

    public Location[] yrot(Location[] l, Location center, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(centerVect);
            double x = locs[i].getX();
            double z = locs[i].getZ();
            locs[i].setX(x * Math.cos(phi) - z * Math.sin(phi));
            locs[i].setZ(x * Math.sin(phi) + z * Math.cos(phi));
            locs[i].add(center);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] zrot(Location[] l, Location center, double phi) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(centerVect);
            double x = locs[i].getX();
            double y = locs[i].getY();
            locs[i].setX(x * Math.cos(phi) + y * Math.sin(phi));
            locs[i].setY(-x * Math.sin(phi) + y * Math.cos(phi));
            ++i;
            ++n2;
        }
        return this.offset(locs, center);
    }

    public Location[] ptrefl(Location[] l, Location l2) {
        Vector vect = l2.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(vect).multiply(-2.0).add(vect);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] refl(Location[] l, Location point, Location dir) {
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = point.clone().toVector().multiply(dir.clone().toVector());
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().toVector().multiply(vect).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] scale(Location[] l, Location center, double d) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(centerVect).multiply(d).add(centerVect);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] dirscale(Location[] l, Location center, Location dir, double d) {
        Vector dirv = dir.clone().toVector().normalize().multiply(d);
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(center).toVector().multiply(dirv).toLocation(tempLoc.getWorld());
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] cdirscale(Location[] l, Location center, double x, double y, double z) {
        Vector centerVect = center.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        Vector vect = new Vector(x, y, z);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().subtract(centerVect).toVector().multiply(vect).toLocation(tempLoc.getWorld()).add(centerVect);
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] midpt(Location[] l) {
        Location loc = new Location(l[0].getWorld(), 0.0, 0.0, 0.0);
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            loc.add(tempLoc);
            ++n2;
        }
        return new Location[]{loc.multiply(1.0 / (double)Array.getLength(l))};
    }

    public Location[] sphloc(Location[] l, double phi, double the, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + r * Math.sin(the) * Math.cos(phi));
            locs[i].setY(tempLoc.getY() + r * Math.cos(the));
            locs[i].setZ(tempLoc.getZ() + r * Math.sin(the) * Math.sin(phi));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] cylloc(Location[] l, double phi, double r, double h) {
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + r * Math.cos(phi));
            locs[i].setY(tempLoc.getY() + h);
            locs[i].setZ(tempLoc.getZ() + r * Math.sin(phi));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] cubeloc(Location[] l, Location l2, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        double d = r / Math.pow(2.0, 0.5);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + d * (2.0 * l2.getX() - 1.0));
            locs[i].setY(tempLoc.getY() + d * (2.0 * l2.getY() - 1.0));
            locs[i].setZ(tempLoc.getZ() + d * (2.0 * l2.getZ() - 1.0));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] ccubeloc(Location[] l, double x, double y, double z, double r) {
        Location[] locs = new Location[Array.getLength(l)];
        double d = r / Math.pow(2.0, 0.5);
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone();
            locs[i].setX(tempLoc.getX() + d * (2.0 * x - 1.0));
            locs[i].setY(tempLoc.getY() + d * (2.0 * y - 1.0));
            locs[i].setZ(tempLoc.getZ() + d * (2.0 * z - 1.0));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] lineloc(Location[] l, Location l2, double p) {
        Vector vect = l2.clone().toVector();
        Location[] locs = new Location[Array.getLength(l)];
        int i = 0;
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            locs[i] = tempLoc.clone().add(vect.clone().subtract(tempLoc.clone().toVector()).multiply(p));
            ++i;
            ++n2;
        }
        return locs;
    }

    public Location[] getLine(Location[] l, Location l2, double d) {
        Vector vect = l2.clone().toVector();
        ArrayList<Location> locs = new ArrayList<Location>();
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            Vector tempVect = tempLoc.toVector();
            int k = (int)(tempVect.distance(vect) * d);
            Vector v = vect.clone().subtract(tempVect).multiply(1.0 / (double)k);
            int i = 0;
            while (i < k) {
                locs.add(tempLoc.clone().add(v.clone().multiply(i)));
                ++i;
            }
            ++n2;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] linkAll(Location[] loc, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        Location[] locationArray = loc;
        int n = loc.length;
        int n2 = 0;
        while (n2 < n) {
            Location l1 = locationArray[n2];
            Location[] locationArray2 = loc;
            int n3 = loc.length;
            int n4 = 0;
            while (n4 < n3) {
                Location l2 = locationArray2[n4];
                if (!l1.equals((Object)l2)) {
                    locs.addAll(Arrays.asList(this.getLine(new Location[]{l1}, l2, d)));
                }
                ++n4;
            }
            ++n2;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getPoly(Location[] l, int n, double r) {
        double phi = Math.PI * 2 / (double)n;
        Location[] locs = new Location[n * Array.getLength(l)];
        int i = 0;
        int j = 0;
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            Location loc = tempLoc.clone().add(r, 0.0, 0.0);
            i = 0;
            while (i < n) {
                locs[j] = this.yrot(new Location[]{loc}, tempLoc, (double)i * phi)[0];
                ++j;
                ++i;
            }
            ++n3;
        }
        return locs;
    }

    public Location[] getPolyOutline(Location[] l, Integer n, double r, double d) {
        Location[] loc = new Location[n.intValue()];
        ArrayList<Location> locs = new ArrayList<Location>();
        int i = 0;
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            loc = this.getPoly(new Location[]{tempLoc}, n, r);
            i = 0;
            while (i < n - 1) {
                locs.addAll(Arrays.asList(this.getLine(new Location[]{loc[i]}, loc[i + 1], d)));
                ++i;
            }
            locs.addAll(Arrays.asList(this.getLine(new Location[]{loc[i]}, loc[0], d)));
            ++n3;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getHelix(Location[] l, double r, double h, double k, double d) {
        int n = (int)(h * 2.0 * Math.PI * r * d);
        double dphi = 1.0 / (k * r * d);
        Location[] locs = new Location[n * Array.getLength(l)];
        int i = 0;
        int j = 0;
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            j = 0;
            while (j < n) {
                locs[i] = this.cylloc(new Location[]{tempLoc}, (double)j * dphi, r, (double)j * h / (double)n)[0];
                ++i;
                ++j;
            }
            ++n3;
        }
        return locs;
    }

    public Location[] getCube(Location[] l, double r) {
        Location[] loc = new Location[4];
        Location[] locs = new Location[8];
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            loc = this.getPoly(new Location[]{tempLoc}, 4, r);
            int i = 0;
            Location[] locationArray2 = loc;
            int n3 = loc.length;
            int n4 = 0;
            while (n4 < n3) {
                Location tempLoc2 = locationArray2[n4];
                double length = loc[0].distance(loc[1]) / 2.0;
                locs[i] = tempLoc2.clone().add(0.0, -length, 0.0);
                locs[++i] = tempLoc2.clone().add(0.0, length, 0.0);
                ++i;
                ++n4;
            }
            ++n2;
        }
        return locs;
    }

    public Location[] getBox(Location l1, Location l2) {
        Location[] locs = new Location[8];
        locs[0] = l1.clone();
        locs[1] = l1.clone().add(l2.getX() - l1.getX(), 0.0, 0.0);
        locs[2] = l1.clone().add(0.0, 0.0, l2.getZ() - l1.getZ());
        locs[3] = l2.clone().add(0.0, l1.getY() - l2.getY(), 0.0);
        int i = 0;
        while (i < 4) {
            locs[i + 4] = locs[i].clone().add(0.0, l2.getY() - l1.getY(), 0.0);
            ++i;
        }
        return locs;
    }

    public Location[] getCubeOutline(Location[] l, double r, double d) {
        Location[] cube = new Location[8];
        ArrayList<Location> locs = new ArrayList<Location>();
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location tempLoc = locationArray[n2];
            cube = this.getCube(new Location[]{tempLoc}, r);
            locs.addAll(Arrays.asList(cube));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[0]}, cube[1], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[1]}, cube[3], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[4]}, cube[5], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[4]}, cube[6], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[1]}, cube[7], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[6]}, cube[7], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[0]}, cube[6], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[0]}, cube[2], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[4]}, cube[2], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[2]}, cube[3], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[3]}, cube[5], d)));
            locs.addAll(Arrays.asList(this.getLine(new Location[]{cube[5]}, cube[7], d)));
            ++n2;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getBoxOutline(Location l1, Location l2, double d) {
        Location[] box = this.getBox(l1, l2);
        ArrayList<Location> locs = new ArrayList<Location>();
        locs.addAll(Arrays.asList(box));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[0]}, box[1], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[0]}, box[2], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[0]}, box[4], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[3]}, box[1], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[3]}, box[2], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[3]}, box[7], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[1]}, box[5], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[2]}, box[6], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[4]}, box[5], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[4]}, box[6], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[7]}, box[5], d)));
        locs.addAll(Arrays.asList(this.getLine(new Location[]{box[7]}, box[6], d)));
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getSphereRand(Location[] l, double r, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        int n = (int)(Math.PI * 4 * r * r * d);
        double phi = 0.0;
        double the = 0.0;
        Random randGen = new Random();
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            int i = 0;
            while (i < n) {
                phi = randGen.nextDouble() * 2.0 * Math.PI;
                the = randGen.nextDouble() * Math.PI;
                locs.add(this.sphloc(new Location[]{tempLoc}, phi, the, r)[0]);
                ++i;
            }
            ++n3;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location[] getSphere(Location[] l, double r, double d) {
        ArrayList<Location> locs = new ArrayList<Location>();
        double the = 0.0;
        double phi = 0.0;
        int n = (int)(Math.PI * r * d);
        Location[] locationArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            Location tempLoc = locationArray[n3];
            the = 0.0;
            int i = 0;
            while (i < n) {
                phi = 0.0;
                int j = 0;
                while (j < n * 2) {
                    locs.add(this.sphloc(new Location[]{tempLoc}, phi, the, r)[0]);
                    phi += Math.PI / (double)n;
                    ++j;
                }
                the += Math.PI / (double)n;
                ++i;
            }
            ++n3;
        }
        return locs.toArray(new Location[locs.size()]);
    }

    public Location getChunkCenter(Chunk chunk) {
        Location loc = new Location(chunk.getWorld(), 0.0, 0.0, 0.0);
        loc.setX((double)(chunk.getX() * 16 + 8));
        loc.setZ((double)(chunk.getZ() * 16 + 8));
        return loc;
    }

    public Chunk[] getChunksSquare(Location l, int r) {
        int size = (2 * r + 1) * (2 * r + 1);
        Location center = l.clone();
        Chunk[] chunks = new Chunk[size];
        int counter = 0;
        int i = 0;
        while (i < 2 * r + 1) {
            Location currentPos = center.clone().add((double)(-16 * r + i * 16), 0.0, (double)(-16 * r));
            int j = 0;
            while (j < 2 * r + 1) {
                chunks[counter] = currentPos.clone().getChunk();
                ++counter;
                currentPos.add(0.0, 0.0, 16.0);
                ++j;
            }
            ++i;
        }
        return chunks;
    }

    public Chunk[] getChunksCircle(Location l, int r) {
        Location center = l.clone();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int i = 0;
        while (i < 2 * r + 1) {
            Location currentPos = center.clone().add((double)(-16 * r + i * 16), 0.0, (double)(-16 * r));
            int j = 0;
            while (j < 2 * r + 1) {
                double dz;
                double dx = center.getX() - currentPos.getX();
                if (dx * dx + (dz = center.getZ() - currentPos.getZ()) * dz < (double)(r * r * 16 * 16 + 1)) {
                    chunks.add(currentPos.clone().getChunk());
                }
                currentPos.add(0.0, 0.0, 16.0);
                ++j;
            }
            ++i;
        }
        return chunks.toArray(new Chunk[chunks.size()]);
    }

    public Chunk[] getChunksBox(Location l1, Location l2) {
        int dx = l2.getChunk().getX() - l1.getChunk().getX();
        int dz = l2.getChunk().getZ() - l1.getChunk().getZ();
        int x = 16;
        int z = 16;
        if (dx < 0) {
            x = -16;
        }
        if (dz < 0) {
            z = -16;
        }
        Chunk[] chunks = new Chunk[(Math.abs(dx) + 1) * (Math.abs(dz) + 1)];
        int counter = 0;
        int i = 0;
        while (i < Math.abs(dx) + 1) {
            Location currentPos = l1.clone().add((double)(i * x), 0.0, 0.0);
            int j = 0;
            while (j < Math.abs(dz) + 1) {
                chunks[counter] = currentPos.getChunk();
                ++counter;
                currentPos.add(0.0, 0.0, (double)z);
                ++j;
            }
            ++i;
        }
        return chunks;
    }
}

