/*
 * Decompiled with CFR 0.152.
 */
package co.jp.yahoo.okamiwolf.api;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import co.jp.yahoo.okamiwolf.BentenComponent;
import co.jp.yahoo.okamiwolf.BentenCore;
import co.jp.yahoo.okamiwolf.api.annotations.AbstractTask;
import co.jp.yahoo.okamiwolf.api.annotations.Dependency;
import co.jp.yahoo.okamiwolf.api.annotations.Patterns;
import co.jp.yahoo.okamiwolf.api.annotations.PropertyFrom;
import co.jp.yahoo.okamiwolf.api.annotations.PropertyTo;
import co.jp.yahoo.okamiwolf.api.annotations.UsePropertyPatterns;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.PluginDescriptionFile;

public class Register {
    private List<BentenComponent> components = new ArrayList<BentenComponent>();

    public void registerComponent(BentenComponent component) {
        if (!this.components.contains((Object)component)) {
            this.components.add(component);
            this.runRegisterTask(component);
        }
    }

    public synchronized void beginRegistering() {
        for (BentenComponent component : this.components) {
            this.runRegisterTask(component);
        }
    }

    public int getRegisteredCount() {
        int registered = 0;
        for (BentenComponent component : this.components) {
            if (!component.isRegistered()) continue;
            ++registered;
        }
        return registered;
    }

    public synchronized void runRegisterTask(BentenComponent component) {
        final Class<?> caller = ((Object)((Object)component)).getClass();
        URL callerLocation = caller.getProtectionDomain().getCodeSource().getLocation();
        try {
            File src;
            try {
                src = new File(callerLocation.toURI());
            }
            catch (URISyntaxException e) {
                src = new File(callerLocation.getPath());
            }
            PluginDescriptionFile desc = BentenCore.getInstance().getPluginLoader().getPluginDescription(src);
            Bukkit.getLogger().info("[BentenCore] Finding classes from " + component.getComponentName() + "... (\u10e6\u02d8\u2323\u02d8\u10e6)");
            try {
                final ArrayList classes = new ArrayList();
                JarFile jar = new JarFile(src);
                jar.stream().iterator().forEachRemaining(new Consumer<JarEntry>(){

                    @Override
                    public void accept(JarEntry e) {
                        if (e.getName().endsWith(".class")) {
                            String className = e.getName().replace('/', '.').substring(0, e.getName().length() - 6);
                            try {
                                Class<?> c = Class.forName(className, false, caller.getClassLoader());
                                if (c != AbstractTask.class && (Effect.class.isAssignableFrom(c) || Condition.class.isAssignableFrom(c) || Expression.class.isAssignableFrom(c) || AbstractTask.class.isAssignableFrom(c))) {
                                    classes.add(c);
                                }
                            }
                            catch (ClassNotFoundException error) {
                                error.printStackTrace();
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                            }
                            catch (ExceptionInInitializerError exceptionInInitializerError) {
                                // empty catch block
                            }
                        }
                    }
                });
                Bukkit.getLogger().info("[BentenCore] Finished registrationing of " + component.getComponentName() + " with " + classes.size() + " classes.");
                Register.register(component, desc, classes.toArray(new Class[classes.size()]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (InvalidDescriptionException e) {
            e.printStackTrace();
        }
    }

    private static synchronized void register(BentenComponent component, PluginDescriptionFile info, Class[] classes) {
        int success = 0;
        Bukkit.getLogger().info("[BentenCore] beginning to process a total of " + classes.length + " from " + component.getComponentName());
        block9: for (Class c : classes) {
            Annotation[] annotations;
            for (Annotation a : annotations = c.getAnnotations()) {
                if (!(a instanceof Dependency)) continue;
                for (String s : ((Dependency)a).value()) {
                    if (Bukkit.getPluginManager().getPlugin(s) != null) continue;
                    Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " does not have its dependencies installed (//\u03c9//)");
                    break block9;
                }
            }
            if (Effect.class.isAssignableFrom(c)) {
                if (c.isAnnotationPresent(Patterns.class)) {
                    Skript.registerEffect((Class)c, (String[])c.getAnnotation(Patterns.class).value());
                    ++success;
                    continue;
                }
                Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " is does not have a pattern! (//\u03c9//)");
                continue;
            }
            if (Condition.class.isAssignableFrom(c)) {
                if (c.isAnnotationPresent(Patterns.class)) {
                    Skript.registerCondition((Class)c, (String[])c.getAnnotation(Patterns.class).value());
                    ++success;
                    continue;
                }
                Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " is does not have a pattern! (//\u03c9//)");
                continue;
            }
            if (Expression.class.isAssignableFrom(c)) {
                Expression ex;
                if (c.isAnnotationPresent(Patterns.class)) {
                    try {
                        ex = (Expression)c.newInstance();
                        Skript.registerExpression((Class)c, (Class)ex.getReturnType(), (ExpressionType)ExpressionType.PROPERTY, (String[])c.getAnnotation(Patterns.class).value());
                        ++success;
                    }
                    catch (InstantiationException e) {
                        Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " could not be instantiated by Bentencore! (//\u03c9//)");
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (c.isAnnotationPresent(UsePropertyPatterns.class) && c.isAnnotationPresent(PropertyFrom.class) && c.isAnnotationPresent(PropertyTo.class)) {
                    try {
                        ex = (Expression)c.newInstance();
                        Skript.registerExpression((Class)c, (Class)ex.getReturnType(), (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] " + c.getAnnotation(PropertyTo.class).value() + " of %" + c.getAnnotation(PropertyFrom.class).value() + "%", "%" + c.getAnnotation(PropertyFrom.class).value() + "%'[s] " + c.getAnnotation(PropertyTo.class).value()});
                        ++success;
                    }
                    catch (InstantiationException e) {
                        Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " could not be instantiated by Bentencore! (//\u03c9//)");
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " is does not have a pattern (//\u03c9//)");
                continue;
            }
            if (!AbstractTask.class.isAssignableFrom(c)) continue;
            try {
                AbstractTask task = (AbstractTask)c.newInstance();
                task.run();
                ++success;
            }
            catch (InstantiationException e) {
                Bukkit.getLogger().info("[BentenCore] " + c.getCanonicalName() + " could not be instantiated by BentenCore!");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        component.setRegistered(true);
        Bukkit.getLogger().info("[BentenCore] Out of " + classes.length + " classes, " + success + " classes were loaded from " + info.getName() + " (\u2606\u03c9\u2606)");
    }
}

