/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.beamer.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import me.limeglass.beamer.lang.BeamerPropertyExpression;
import me.limeglass.beamer.protocol.beam.Beam;
import me.limeglass.beamer.utils.annotations.Changers;
import me.limeglass.beamer.utils.annotations.Properties;
import me.limeglass.beamer.utils.annotations.PropertiesAddition;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Beam start and ending locations")
@Description(value={"Returns/Sets the starting or ending location of the beam."})
@Properties(value={"beams", "(1\u00a6starting|2\u00a6ending) (location|postions)[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="[guardian] [beam[s]]")
@Changers(value={Changer.ChangeMode.SET})
public class ExprBeamLocation
extends BeamerPropertyExpression<Beam, Location> {
    protected Location[] get(Event event, Beam[] beams) {
        for (Beam beam : beams) {
            if (this.patternMark == 1) {
                this.collection.add(beam.getStartingPosition());
                continue;
            }
            this.collection.add(beam.getEndingPosition());
        }
        return this.collection.toArray(new Location[this.collection.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        Location location = (Location)delta[0];
        for (Beam beam : this.expressions.getAll(event, Beam.class)) {
            if (this.patternMark == 1) {
                beam.setStartingPosition(location);
                continue;
            }
            beam.setEndingPosition(location);
        }
    }
}

