/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.beamer.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import java.util.Arrays;
import me.limeglass.beamer.Beamer;
import me.limeglass.beamer.Metrics;
import me.limeglass.beamer.Syntax;
import me.limeglass.beamer.utils.ReflectionUtil;
import me.limeglass.beamer.utils.annotations.Disabled;
import me.limeglass.beamer.utils.annotations.ExpressionProperty;
import me.limeglass.beamer.utils.annotations.Patterns;
import me.limeglass.beamer.utils.annotations.Properties;
import me.limeglass.beamer.utils.annotations.PropertiesAddition;

public class Register {
    public static void metrics(Metrics metrics) {
        metrics.addCustomChart(new Metrics.SimplePie("skript_version"){

            @Override
            public String getValue() {
                return Skript.getVersion().toString();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("use_encryption"){

            @Override
            public String getValue() {
                return Beamer.getInstance().getConfig().getBoolean("security.encryption.enabled", false) + "";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("use_breaches"){

            @Override
            public String getValue() {
                return Beamer.getInstance().getConfig().getBoolean("security.breaches.enabled", false) + "";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("use_password"){

            @Override
            public String getValue() {
                return Beamer.getInstance().getConfig().getBoolean("security.password.enabled", false) + "";
            }
        });
        Beamer.debugMessage("Metrics registered!");
    }

    static {
        for (Class<?> clazz : ReflectionUtil.getClasses(Beamer.getInstance(), Beamer.getInstance().getPackageName())) {
            if (clazz.getName().contains("serverinstances") && !Beamer.getInstance().getConfiguration("config").getBoolean("ServerInstances", false) || clazz.isAnnotationPresent(Disabled.class)) continue;
            Object[] syntax = null;
            ExpressionType type = ExpressionType.COMBINED;
            if (clazz.isAnnotationPresent(Patterns.class)) {
                syntax = Syntax.register(clazz, clazz.getAnnotation(Patterns.class).value());
            } else {
                String[] values;
                if (!PropertyExpression.class.isAssignableFrom(clazz) || !clazz.isAnnotationPresent(Properties.class)) continue;
                type = ExpressionType.PROPERTY;
                String[] properties = clazz.getAnnotation(Properties.class).value();
                String additions = clazz.isAnnotationPresent(PropertiesAddition.class) ? " " + clazz.getAnnotation(PropertiesAddition.class).value() + " " : " ";
                String input1 = "[the] ";
                String input2 = "";
                if (properties.length > 2 && properties[2] != null) {
                    int var = Integer.parseInt(properties[2].substring(1, 2));
                    if (var == 1) {
                        input1 = properties[2].substring(3, properties[2].length());
                    } else {
                        input2 = properties[2].substring(3, properties[2].length());
                    }
                }
                if ((syntax = Syntax.register(clazz, values = new String[]{Beamer.getNameplate() + input1 + " " + properties[1] + " (of|from|in)" + additions + "%" + properties[0] + "%", Beamer.getNameplate() + input2 + "%" + properties[0] + "%'[s]" + additions.replace("[the] ", "") + properties[1]})) == null) {
                    Beamer.debugMessage("&cThere was an issue registering the syntax for " + clazz.getName() + ". Make sure that the SyntaxToggles.yml is set for this syntax.");
                }
            }
            if (syntax == null) continue;
            if (Effect.class.isAssignableFrom(clazz)) {
                Skript.registerEffect(clazz, (String[])syntax);
                Beamer.debugMessage("&5Registered Effect " + clazz.getSimpleName() + " (" + clazz.getCanonicalName() + ") with syntax " + Arrays.toString(syntax));
                continue;
            }
            if (Condition.class.isAssignableFrom(clazz)) {
                Skript.registerCondition(clazz, (String[])syntax);
                Beamer.debugMessage("&5Registered Condition " + clazz.getSimpleName() + " (" + clazz.getCanonicalName() + ") with syntax " + Arrays.toString(syntax));
                continue;
            }
            if (!Expression.class.isAssignableFrom(clazz)) continue;
            if (clazz.isAnnotationPresent(ExpressionProperty.class)) {
                type = clazz.getAnnotation(ExpressionProperty.class).value();
            }
            try {
                Skript.registerExpression(clazz, (Class)((Expression)clazz.newInstance()).getReturnType(), (ExpressionType)type, (String[])syntax);
                Beamer.debugMessage("&5Registered Expression " + type.toString() + " " + clazz.getSimpleName() + " (" + clazz.getCanonicalName() + ") with syntax " + Arrays.toString(syntax));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                Beamer.consoleMessage("&cFailed to register expression " + clazz.getCanonicalName());
                e.printStackTrace();
            }
        }
    }
}

