/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.beamer;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.limeglass.beamer.Metrics;
import me.limeglass.beamer.SpigotConfigSaver;
import me.limeglass.beamer.elements.Register;
import me.limeglass.beamer.utils.Utils;
import net.jaxonbrown.guardianBeam.beam.ClientBeam;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Beamer
extends JavaPlugin {
    private static Map<String, FileConfiguration> files = new HashMap<String, FileConfiguration>();
    private String packageName = "me.limeglass.beamer";
    private static String prefix = "&7[&bBeamer&7] &9";
    private static String nameplate = "[Beamer] ";
    private static Beamer instance;
    private SkriptAddon addon;
    private Metrics metrics;

    public void onEnable() {
        this.addon = Skript.registerAddon((JavaPlugin)this);
        instance = this;
        Classes.registerClass((ClassInfo)new ClassInfo(ClientBeam.class, "beam"));
        this.saveDefaultConfig();
        File config = new File(this.getDataFolder(), "config.yml");
        if (!Objects.equals(this.getDescription().getVersion(), this.getConfig().getString("version"))) {
            Beamer.consoleMessage("&dNew update found! Updating files now...");
            if (config.exists()) {
                new SpigotConfigSaver(this).execute();
            }
        }
        for (String name : Arrays.asList("config", "syntax")) {
            File file = new File(this.getDataFolder(), name + ".yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                this.saveResource(file.getName(), false);
            }
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            files.put(name, (FileConfiguration)configuration);
        }
        this.metrics = new Metrics(this);
        Register.metrics(this.metrics);
        if (!this.getConfig().getBoolean("DisableRegisteredInfo", false)) {
            Bukkit.getLogger().info(nameplate + "has been enabled!");
        }
    }

    public SkriptAddon getAddonInstance() {
        return this.addon;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static Beamer getInstance() {
        return instance;
    }

    public static String getPrefix() {
        return prefix;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public FileConfiguration getConfiguration(String file) {
        return files.containsKey(file) ? files.get(file) : null;
    }

    public static void save(String configuration) {
        try {
            File configurationFile = new File(instance.getDataFolder(), configuration + ".yml");
            instance.getConfiguration(configuration).save(configurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void debugMessage(String ... messages) {
        if (instance.getConfig().getBoolean("debug")) {
            for (String text : messages) {
                Beamer.consoleMessage("&b" + text);
            }
        }
    }

    public static void infoMessage(String ... messages) {
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                Bukkit.getLogger().info(Beamer.getNameplate() + text);
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }

    public static void consoleMessage(String ... messages) {
        if (instance.getConfig().getBoolean("DisableConsoleMessages", false)) {
            return;
        }
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                if (instance.getConfig().getBoolean("DisableConsoleColour", false)) {
                    Beamer.infoMessage(ChatColor.stripColor((String)Utils.cc(text)));
                    continue;
                }
                Bukkit.getConsoleSender().sendMessage(Utils.cc(prefix + text));
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }
}

