/*
 * Decompiled with CFR 0.152.
 */
package me.nicofisi.baskup;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import scala.Function2;
import scala.Unit;

public class WatchDir {
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final boolean recursive;
    private boolean trace = false;
    private final Function2<WatchEvent.Kind, Path, Unit> onEvent;

    static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }

    private void register(Path path) throws IOException {
        WatchKey watchKey = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.trace) {
            Path path2 = this.keys.get(watchKey);
            if (path2 == null) {
                System.out.format("register: %s\n", path);
            } else if (!path.equals(path2)) {
                System.out.format("update: %s -> %s\n", path2, path);
            }
        }
        this.keys.put(watchKey, path);
    }

    private void registerAll(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                WatchDir.this.register(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    WatchDir(Path path, boolean bl, Function2<WatchEvent.Kind, Path, Unit> function2) throws IOException {
        this.recursive = bl;
        this.onEvent = function2;
        if (bl) {
            this.registerAll(path);
        } else {
            this.register(path);
        }
        this.trace = true;
    }

    void processEvents() {
        while (true) {
            WatchKey watchKey;
            try {
                watchKey = this.watcher.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            Path path = this.keys.get(watchKey);
            if (path == null) {
                System.err.println("WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent watchEvent2 = WatchDir.cast(watchEvent);
                Path path2 = (Path)watchEvent2.context();
                Path path3 = path.resolve(path2);
                this.onEvent.apply(watchEvent2.kind(), path3);
                if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(path3, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(path3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            boolean bl = watchKey.reset();
            if (bl) continue;
            this.keys.remove(watchKey);
            if (this.keys.isEmpty()) break;
        }
    }
}

