/*
 * Decompiled with CFR 0.152.
 */
package me.nicofisi.baskup;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import me.nicofisi.baskup.BaskupJava;
import me.nicofisi.baskup.WatchDir;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Unit;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;

public final class Baskup$ {
    public static Baskup$ MODULE$;
    private final BaskupJava plugin;
    private final Logger logger;
    private WatchService watcher;
    private File scriptsBackupDir;
    private File scriptsDir;
    private Path scriptsPath;
    private final SimpleDateFormat fileNameDateFormat;
    private boolean shuttingDown;
    private final String DataFileName;

    static {
        new Baskup$();
    }

    public BaskupJava plugin() {
        return this.plugin;
    }

    public Logger logger() {
        return this.logger;
    }

    public WatchService watcher() {
        return this.watcher;
    }

    public void watcher_$eq(WatchService x$1) {
        this.watcher = x$1;
    }

    public File scriptsBackupDir() {
        return this.scriptsBackupDir;
    }

    public void scriptsBackupDir_$eq(File x$1) {
        this.scriptsBackupDir = x$1;
    }

    public File scriptsDir() {
        return this.scriptsDir;
    }

    public void scriptsDir_$eq(File x$1) {
        this.scriptsDir = x$1;
    }

    public Path scriptsPath() {
        return this.scriptsPath;
    }

    public void scriptsPath_$eq(Path x$1) {
        this.scriptsPath = x$1;
    }

    public SimpleDateFormat fileNameDateFormat() {
        return this.fileNameDateFormat;
    }

    private boolean shuttingDown() {
        return this.shuttingDown;
    }

    private void shuttingDown_$eq(boolean x$1) {
        this.shuttingDown = x$1;
    }

    public String DataFileName() {
        return this.DataFileName;
    }

    public void onEnable() {
        Plugin skript = Bukkit.getPluginManager().getPlugin("Skript");
        if (skript == null) {
            this.logger().severe("Skript not found. Baskup won't do anything.");
            this.plugin().setEnabledPublic(false);
            return;
        }
        this.scriptsBackupDir_$eq(new File(skript.getDataFolder(), "backups/scripts"));
        this.scriptsDir_$eq(new File(skript.getDataFolder(), "scripts"));
        this.scriptsPath_$eq(this.scriptsDir().toPath());
        Files.walkFileTree(this.scriptsPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                block0: {
                    if (!((Object)file).toString().toLowerCase().endsWith(".sk")) break block0;
                    Baskup$.MODULE$.runBackup(file.toFile(), true);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Thread t = new Thread(() -> {
            block2: {
                try {
                    new WatchDir(MODULE$.scriptsPath(), true, (Function2<WatchEvent.Kind, Path, Unit>)(Function2<WatchEvent.Kind, Path, Object> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Baskup$.$anonfun$onEnable$2(x0$1, x1$1);
                        return BoxedUnit.UNIT;
                    }).processEvents();
                }
                catch (ClosedWatchServiceException ex) {
                    if (MODULE$.shuttingDown()) break block2;
                    MODULE$.logger().severe("The file update watcher has been unexpectedly closed.");
                    MODULE$.logger().severe("No further scripts will be backed up before a restart.");
                    ex.printStackTrace();
                }
            }
        });
        t.setName("Baskup File Watcher Thread");
        t.start();
    }

    public void runBackup(File scriptFile, boolean ignoreIfSame) {
        Option<File> option = this.getExistingBackupDir(scriptFile);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            File scriptBackupDir = (File)some.value();
            File dataFile = new File(scriptBackupDir, this.DataFileName());
            try {
                File lastBackupFile;
                if (ignoreIfSame && dataFile.exists() && (lastBackupFile = new File(scriptBackupDir, Source$.MODULE$.fromFile(dataFile, Codec$.MODULE$.fallbackSystemCodec()).mkString().trim())).exists() && Source$.MODULE$.fromFile(lastBackupFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().sameElements(Source$.MODULE$.fromFile(scriptFile, Codec$.MODULE$.fallbackSystemCodec()).getLines())) {
                    return;
                }
            }
            catch (Exception ex) {
                this.logger().warning(new StringBuilder(101).append("An error has occurred while checking whether ").append(scriptFile.getAbsolutePath()).append(" needs to be backed up (it will be backed up regardless)").toString());
                ex.printStackTrace();
            }
            String fileName = new StringBuilder(4).append((String)new StringOps(Predef$.MODULE$.augmentString(scriptFile.getName())).dropRight(3)).append("-").append(this.fileNameDateFormat().format(new Date())).append(".sk").toString();
            File backupFile = new File(scriptBackupDir, fileName);
            if (backupFile.exists()) {
                this.logger().warning(new StringBuilder(25).append(backupFile.getAbsolutePath()).append(" somehow already exists, ").append(new StringBuilder(32).append("so ").append(scriptFile.getAbsolutePath()).append(" won't be backed up this time").toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Files.copy(scriptFile.toPath(), backupFile.toPath(), new CopyOption[0]);
                PrintWriter pw = new PrintWriter(dataFile);
                pw.write(fileName);
                pw.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.warnAboutDotSkBeforeEnd(scriptFile);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public boolean runBackup$default$2() {
        return false;
    }

    public void warnAboutDotSkBeforeEnd(File scriptFile) {
        this.logger().warning(new StringBuilder(183).append("The path of ").append(scriptFile.getAbsolutePath()).append(" contains '.sk' somewhere before the end. ").append("The script won't be backed up until you fix this by renaming either the script ").append("or one of the parent directories, whichever needed").toString());
    }

    public Option<File> getExistingBackupDir(File scriptFile) {
        Option option;
        Path relScriptPath = this.scriptsPath().relativize(scriptFile.toPath());
        if (scriptFile.getAbsolutePath().toLowerCase().indexOf(".sk") != scriptFile.getAbsolutePath().length() - 3) {
            option = None$.MODULE$;
        } else {
            File backupDir = new File(this.scriptsBackupDir(), ((Object)relScriptPath).toString());
            backupDir.mkdirs();
            option = new Some<File>(backupDir);
        }
        return option;
    }

    public void onDisable() {
        this.shuttingDown_$eq(true);
        Option$.MODULE$.apply(this.watcher()).foreach((Function1<WatchService, Object> & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$onEnable$2(WatchEvent.Kind x0$1, Path x1$1) {
        block5: {
            block4: {
                var3_2 = new Tuple2<WatchEvent.Kind, Path>(x0$1, x1$1);
                if (var3_2 == null) break block4;
                kind = var3_2._1();
                path = var3_2._2();
                if (!path.toString().toLowerCase().endsWith(".sk")) ** GOTO lbl-1000
                v0 = kind;
                var6_5 = StandardWatchEventKinds.ENTRY_MODIFY;
                if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null) && Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        Baskup$.MODULE$.runBackup(path.toFile(), Baskup$.MODULE$.runBackup$default$2());
                        v1 = BoxedUnit.UNIT;
                    }
                    catch (Exception ex) {
                        Baskup$.MODULE$.logger().warning(new StringBuilder(45).append("An error has occurred while trying to backup ").append(path.toString()).toString());
                        ex.printStackTrace();
                        v1 = BoxedUnit.UNIT;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                break block5;
            }
            throw new MatchError(var3_2);
        }
        var2_7 = v1;
    }

    private Baskup$() {
        MODULE$ = this;
        this.plugin = BaskupJava.get();
        this.logger = this.plugin().getLogger();
        this.fileNameDateFormat = new SimpleDateFormat("YYYY-MM-DD_HH-mm-ss");
        this.shuttingDown = false;
        this.DataFileName = ".baskup_data";
    }
}

