/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.advancements.util;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Advancements {
    private String id;
    private String title;
    private String parent;
    private String trigger;
    private String icon;
    private String description;
    private String background;
    private String frame;
    private boolean announce;
    private List<ItemStack> items;

    public Advancements(String id) {
        this.id = id;
        this.items = Lists.newArrayList();
        this.announce = true;
    }

    public String getID() {
        return this.id;
    }

    public String getIcon() {
        return this.icon;
    }

    public Advancements withIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Advancements withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getBackground() {
        return this.background;
    }

    public Advancements withBackground(String url) {
        this.background = url;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Advancements withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getParent() {
        return this.parent;
    }

    public Advancements withParent(String parent) {
        this.parent = parent;
        return this;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public Advancements withTrigger(String trigger) {
        this.trigger = trigger;
        return this;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public Advancements withItem(ItemStack is) {
        this.items.add(is);
        return this;
    }

    public String getFrame() {
        return this.frame;
    }

    public Advancements withFrame(String frame) {
        this.frame = frame;
        return this;
    }

    public boolean getAnnouncement() {
        return this.announce;
    }

    public Advancements withAnnouncement(boolean announce) {
        this.announce = announce;
        return this;
    }

    public String getJSON() {
        JSONObject json = new JSONObject();
        JSONObject icon = new JSONObject();
        icon.put((Object)"item", (Object)this.getIcon());
        JSONObject display = new JSONObject();
        display.put((Object)"icon", (Object)icon);
        display.put((Object)"title", (Object)this.getTitle());
        display.put((Object)"description", (Object)this.getDescription());
        display.put((Object)"background", (Object)this.getBackground());
        display.put((Object)"frame", (Object)this.getFrame());
        display.put((Object)"announce_to_chat", (Object)this.getAnnouncement());
        json.put((Object)"parent", (Object)this.getParent());
        JSONObject criteria = new JSONObject();
        JSONObject conditions = new JSONObject();
        JSONObject elytra = new JSONObject();
        JSONArray itemArray = new JSONArray();
        JSONObject itemJSON = new JSONObject();
        for (ItemStack i : this.getItems()) {
            itemJSON.put((Object)"item", (Object)("minecraft:" + i.getType().name().toLowerCase()));
            itemJSON.put((Object)"amount", (Object)i.getAmount());
            itemArray.add((Object)itemJSON);
        }
        conditions.put((Object)"items", (Object)itemArray);
        elytra.put((Object)"trigger", (Object)this.getTrigger());
        elytra.put((Object)"conditions", (Object)conditions);
        criteria.put((Object)"elytra", (Object)elytra);
        json.put((Object)"criteria", (Object)criteria);
        json.put((Object)"display", (Object)display);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = gson.toJson((Object)json);
        return prettyJson;
    }

    public void save(String world) {
        File f = new File(String.valueOf(Bukkit.getWorld((String)world).getWorldFolder().getAbsolutePath()) + File.separator + "data" + File.separator + "advancements" + File.separator + "minecraft" + File.separator + "story");
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(f.getAbsolutePath()) + File.separator + this.getID() + ".json");
            fileWriter.write(this.getJSON());
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

