/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class PermissionOverrideAction
extends AuditableRestAction<PermissionOverride> {
    private long allow = 0L;
    private long deny = 0L;
    private final Channel channel;
    private final Member member;
    private final Role role;

    public PermissionOverrideAction(JDA api, Route.CompiledRoute route, Channel channel, Member member) {
        super(api, route);
        this.channel = channel;
        this.member = member;
        this.role = null;
    }

    public PermissionOverrideAction(JDA api, Route.CompiledRoute route, Channel channel, Role role) {
        super(api, route);
        this.channel = channel;
        this.member = null;
        this.role = role;
    }

    @Override
    public PermissionOverrideAction setCheck(BooleanSupplier checks) {
        return (PermissionOverrideAction)super.setCheck(checks);
    }

    public long getAllow() {
        return this.allow;
    }

    public List<Permission> getAllowedPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.allow));
    }

    public long getDeny() {
        return this.deny;
    }

    public List<Permission> getDeniedPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.deny));
    }

    public long getInherited() {
        return (this.allow ^ 0xFFFFFFFFFFFFFFFFL) & (this.deny ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public List<Permission> getInheritedPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.getInherited()));
    }

    public boolean isMember() {
        return this.member != null;
    }

    public boolean isRole() {
        return this.role != null;
    }

    @CheckReturnValue
    public PermissionOverrideAction setAllow(long allowBits) {
        Checks.notNegative(allowBits, "Granted permissions value");
        Checks.check(allowBits <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        this.allow = allowBits;
        return this;
    }

    @CheckReturnValue
    public PermissionOverrideAction setAllow(Collection<Permission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this.setAllow(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setAllow(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermissionOverrideAction setAllow(Permission ... permissions) {
        if (permissions == null || permissions.length < 1) {
            return this.setAllow(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setAllow(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermissionOverrideAction setDeny(long denyBits) {
        Checks.notNegative(denyBits, "Denied permissions value");
        Checks.check(denyBits <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        this.deny = denyBits;
        return this;
    }

    @CheckReturnValue
    public PermissionOverrideAction setDeny(Collection<Permission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this.setDeny(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setDeny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermissionOverrideAction setDeny(Permission ... permissions) {
        if (permissions == null || permissions.length < 1) {
            return this.setDeny(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setDeny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermissionOverrideAction setPermissions(long allowBits, long denyBits) {
        this.setAllow(allowBits);
        this.setDeny(denyBits);
        return this;
    }

    @CheckReturnValue
    public PermissionOverrideAction setPermissions(Collection<Permission> grantPermissions, Collection<Permission> denyPermissions) {
        this.setAllow(grantPermissions);
        this.setDeny(denyPermissions);
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("type", this.isRole() ? "role" : "member");
        object.put("allow", this.allow);
        object.put("deny", this.deny);
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<PermissionOverride> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        boolean isMember = this.isMember();
        long id = isMember ? this.member.getUser().getIdLong() : this.role.getIdLong();
        JSONObject object = (JSONObject)request.getRawBody();
        PermissionOverrideImpl override = new PermissionOverrideImpl(this.channel, id, isMember ? this.member : this.role);
        override.setAllow(object.getLong("allow"));
        override.setDeny(object.getLong("deny"));
        ((AbstractChannelImpl)this.channel).getOverrideMap().put(id, override);
        request.onSuccess(override);
    }

    private void checkNull(Collection<?> collection, String name) {
        Checks.notNull(collection, name);
        collection.forEach(e -> Checks.notNull(e, name));
    }

    private <T> void checkNull(T[] arr, String name) {
        Checks.notNull(arr, name);
        for (T e : arr) {
            Checks.notNull(e, name);
        }
    }
}

