/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers.impl;

import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.audio.AudioConnection;
import net.dv8tion.jda.core.audio.AudioReceiveHandler;
import net.dv8tion.jda.core.audio.AudioSendHandler;
import net.dv8tion.jda.core.audio.SpeakingMode;
import net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.audio.hooks.ListenerProxy;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.PermissionUtil;

public class AudioManagerImpl
implements AudioManager {
    public static final ThreadGroup AUDIO_THREADS = new ThreadGroup("jda-audio");
    public final ReentrantLock CONNECTION_LOCK = new ReentrantLock();
    protected final ListenerProxy connectionListener = new ListenerProxy();
    protected final GuildImpl guild;
    protected VoiceChannel queuedAudioConnection = null;
    protected AudioConnection audioConnection = null;
    protected EnumSet<SpeakingMode> speakingModes = EnumSet.of(SpeakingMode.VOICE);
    protected AudioSendHandler sendHandler;
    protected AudioReceiveHandler receiveHandler;
    protected long queueTimeout = 100L;
    protected boolean shouldReconnect = true;
    protected boolean selfMuted = false;
    protected boolean selfDeafened = false;
    protected long timeout = 10000L;

    public AudioManagerImpl(GuildImpl guild) {
        this.guild = guild;
    }

    public AudioConnection getAudioConnection() {
        return this.audioConnection;
    }

    @Override
    public void openAudioConnection(VoiceChannel channel) {
        Checks.notNull(channel, "Provided VoiceChannel");
        if (!this.getGuild().equals(channel.getGuild())) {
            throw new IllegalArgumentException("The provided VoiceChannel is not a part of the Guild that this AudioManager handles.Please provide a VoiceChannel from the proper Guild");
        }
        if (!this.getGuild().isAvailable()) {
            throw new GuildUnavailableException("Cannot open an Audio Connection with an unavailable guild. Please wait until this Guild is available to open a connection.");
        }
        Member self = this.getGuild().getSelfMember();
        if (this.audioConnection == null) {
            this.checkChannel(channel, self);
            this.queuedAudioConnection = channel;
            this.getJDA().getClient().queueAudioConnect(channel);
        } else {
            if (channel.equals(this.audioConnection.getChannel())) {
                return;
            }
            this.checkChannel(channel, self);
            this.getJDA().getClient().queueAudioConnect(channel);
            this.audioConnection.setChannel(channel);
        }
    }

    private void checkChannel(VoiceChannel channel, Member self) {
        EnumSet<Permission> perms = Permission.toEnumSet(PermissionUtil.getEffectivePermission((Channel)channel, self));
        if (!perms.contains((Object)Permission.VOICE_CONNECT)) {
            throw new InsufficientPermissionException(Permission.VOICE_CONNECT);
        }
        int userLimit = channel.getUserLimit();
        if (userLimit > 0 && !perms.contains((Object)Permission.ADMINISTRATOR) && userLimit <= channel.getMembers().size() && !perms.contains((Object)Permission.VOICE_MOVE_OTHERS)) {
            throw new InsufficientPermissionException(Permission.VOICE_MOVE_OTHERS, "Unable to connect to VoiceChannel due to userlimit! Requires permission VOICE_MOVE_OTHERS to bypass");
        }
    }

    @Override
    public void closeAudioConnection() {
        this.closeAudioConnection(ConnectionStatus.NOT_CONNECTED);
    }

    public void closeAudioConnection(ConnectionStatus reason) {
        MiscUtil.locked(this.CONNECTION_LOCK, () -> {
            this.queuedAudioConnection = null;
            if (this.audioConnection != null) {
                this.audioConnection.close(reason);
            } else {
                this.getJDA().getClient().queueAudioDisconnect(this.getGuild());
            }
            this.audioConnection = null;
        });
    }

    @Override
    public void setSpeakingMode(Collection<SpeakingMode> mode) {
        Checks.notEmpty(mode, "Speaking Mode");
        this.speakingModes = EnumSet.copyOf(mode);
        if (this.audioConnection != null) {
            this.audioConnection.setSpeakingMode(this.speakingModes);
        }
    }

    @Override
    public EnumSet<SpeakingMode> getSpeakingMode() {
        return EnumSet.copyOf(this.speakingModes);
    }

    @Override
    public JDAImpl getJDA() {
        return this.getGuild().getJDA();
    }

    @Override
    public GuildImpl getGuild() {
        return this.guild;
    }

    @Override
    public boolean isAttemptingToConnect() {
        return this.queuedAudioConnection != null;
    }

    @Override
    public VoiceChannel getQueuedAudioConnection() {
        return this.queuedAudioConnection;
    }

    @Override
    public VoiceChannel getConnectedChannel() {
        return this.audioConnection == null ? null : this.audioConnection.getChannel();
    }

    @Override
    public boolean isConnected() {
        return this.audioConnection != null;
    }

    @Override
    public void setConnectTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getConnectTimeout() {
        return this.timeout;
    }

    @Override
    public void setSendingHandler(AudioSendHandler handler) {
        this.sendHandler = handler;
        if (this.audioConnection != null) {
            this.audioConnection.setSendingHandler(handler);
        }
    }

    @Override
    public AudioSendHandler getSendingHandler() {
        return this.sendHandler;
    }

    @Override
    public void setReceivingHandler(AudioReceiveHandler handler) {
        this.receiveHandler = handler;
        if (this.audioConnection != null) {
            this.audioConnection.setReceivingHandler(handler);
        }
    }

    @Override
    public AudioReceiveHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener.setListener(listener);
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this.connectionListener.getListener();
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        if (this.audioConnection != null) {
            return this.audioConnection.getConnectionStatus();
        }
        return ConnectionStatus.NOT_CONNECTED;
    }

    @Override
    public void setAutoReconnect(boolean shouldReconnect) {
        this.shouldReconnect = shouldReconnect;
        if (this.audioConnection != null) {
            this.audioConnection.setAutoReconnect(shouldReconnect);
        }
    }

    @Override
    public boolean isAutoReconnect() {
        return this.shouldReconnect;
    }

    @Override
    public void setSelfMuted(boolean muted) {
        if (this.selfMuted != muted) {
            this.selfMuted = muted;
            this.updateVoiceState();
        }
    }

    @Override
    public boolean isSelfMuted() {
        return this.selfMuted;
    }

    @Override
    public void setSelfDeafened(boolean deafened) {
        if (this.selfDeafened != deafened) {
            this.selfDeafened = deafened;
            this.updateVoiceState();
        }
    }

    @Override
    public boolean isSelfDeafened() {
        return this.selfDeafened;
    }

    public ConnectionListener getListenerProxy() {
        return this.connectionListener;
    }

    public void setAudioConnection(AudioConnection audioConnection) {
        this.audioConnection = audioConnection;
        if (audioConnection == null) {
            return;
        }
        this.queuedAudioConnection = null;
        audioConnection.setSendingHandler(this.sendHandler);
        audioConnection.setReceivingHandler(this.receiveHandler);
        audioConnection.setQueueTimeout(this.queueTimeout);
        audioConnection.setSpeakingMode(this.speakingModes);
    }

    public void prepareForRegionChange() {
        VoiceChannel queuedChannel = this.audioConnection.getChannel();
        this.closeAudioConnection(ConnectionStatus.AUDIO_REGION_CHANGE);
        this.queuedAudioConnection = queuedChannel;
    }

    public void setQueuedAudioConnection(VoiceChannel channel) {
        this.queuedAudioConnection = channel;
    }

    public void setConnectedChannel(VoiceChannel channel) {
        if (this.audioConnection != null) {
            this.audioConnection.setChannel(channel);
        }
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
        if (this.audioConnection != null) {
            this.audioConnection.setQueueTimeout(queueTimeout);
        }
    }

    protected void updateVoiceState() {
        if (this.isConnected() || this.isAttemptingToConnect()) {
            VoiceChannel channel = this.isConnected() ? this.getConnectedChannel() : this.getQueuedAudioConnection();
            this.getJDA().getClient().queueAudioConnect(channel);
        }
    }

    protected void finalize() {
        if (this.audioConnection != null) {
            LOG.warn("Finalized AudioManager with active audio connection. GuildId: {}", (Object)this.getGuild().getId());
            this.audioConnection.close(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
        }
        this.audioConnection = null;
    }
}

