/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Objects;
import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.client.entities.CallUser;
import net.dv8tion.jda.client.entities.CallableChannel;
import net.dv8tion.jda.client.entities.impl.CallImpl;
import net.dv8tion.jda.client.entities.impl.CallVoiceStateImpl;
import net.dv8tion.jda.client.events.call.voice.CallVoiceJoinEvent;
import net.dv8tion.jda.client.events.call.voice.CallVoiceLeaveEvent;
import net.dv8tion.jda.client.events.call.voice.CallVoiceSelfDeafenEvent;
import net.dv8tion.jda.client.events.call.voice.CallVoiceSelfMuteEvent;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceDeafenEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceGuildDeafenEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceGuildMuteEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceJoinEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceLeaveEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceMoveEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceMuteEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceSelfDeafenEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceSelfMuteEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceSuppressEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class VoiceStateUpdateHandler
extends SocketHandler {
    public VoiceStateUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        Long guildId;
        Long l = guildId = content.isNull("guild_id") ? null : Long.valueOf(content.getLong("guild_id"));
        if (guildId != null && this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        if (guildId != null) {
            this.handleGuildVoiceState(content);
        } else {
            this.handleCallVoiceState(content);
        }
        return null;
    }

    private void handleGuildVoiceState(JSONObject content) {
        VoiceChannelImpl channel;
        long userId = content.getLong("user_id");
        long guildId = content.getLong("guild_id");
        Long channelId = !content.isNull("channel_id") ? Long.valueOf(content.getLong("channel_id")) : null;
        String sessionId = !content.isNull("session_id") ? content.getString("session_id") : null;
        boolean selfMuted = content.getBoolean("self_mute");
        boolean selfDeafened = content.getBoolean("self_deaf");
        boolean guildMuted = content.getBoolean("mute");
        boolean guildDeafened = content.getBoolean("deaf");
        boolean suppressed = content.getBoolean("suppress");
        Guild guild = this.getJDA().getGuildById(guildId);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for a Guild that has yet to be cached. JSON: {}", (Object)content);
            return;
        }
        VoiceChannelImpl voiceChannelImpl = channel = channelId != null ? (VoiceChannelImpl)guild.getVoiceChannelById(channelId) : null;
        if (channel == null && channelId != null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received VOICE_STATE_UPDATE for a VoiceChannel that has yet to be cached. JSON: {}", (Object)content);
            return;
        }
        MemberImpl member = (MemberImpl)guild.getMemberById(userId);
        if (member == null) {
            long idHash = guildId ^ userId;
            this.getJDA().getEventCache().cache(EventCache.Type.MEMBER, idHash, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received VOICE_STATE_UPDATE for a Member that has yet to be cached. HASH_ID: {} JSON: {}", (Object)idHash, (Object)content);
            return;
        }
        GuildVoiceStateImpl vState = (GuildVoiceStateImpl)member.getVoiceState();
        if (vState == null) {
            return;
        }
        vState.setSessionId(sessionId);
        if (!Objects.equals(channel, vState.getChannel())) {
            VoiceChannelImpl oldChannel = (VoiceChannelImpl)vState.getChannel();
            vState.setConnectedChannel(channel);
            if (oldChannel == null) {
                channel.getConnectedMembersMap().put(userId, member);
                this.getJDA().getEventManager().handle(new GuildVoiceJoinEvent((JDA)this.getJDA(), this.responseNumber, member));
            } else if (channel == null) {
                oldChannel.getConnectedMembersMap().remove(userId);
                if (guild.getSelfMember().equals(member)) {
                    this.getJDA().getClient().updateAudioConnection(guildId, null);
                }
                this.getJDA().getEventManager().handle(new GuildVoiceLeaveEvent(this.getJDA(), this.responseNumber, member, oldChannel));
            } else {
                AudioManagerImpl mng = (AudioManagerImpl)this.getJDA().getAudioManagerMap().get(guildId);
                if (guild.getSelfMember().equals(member) && mng != null) {
                    if (mng.isConnected() || mng.isAttemptingToConnect()) {
                        mng.setConnectedChannel(channel);
                    }
                    if (mng.isConnected()) {
                        this.getJDA().getClient().updateAudioConnection(guildId, channel);
                    }
                }
                channel.getConnectedMembersMap().put(userId, member);
                oldChannel.getConnectedMembersMap().remove(userId);
                this.getJDA().getEventManager().handle(new GuildVoiceMoveEvent(this.getJDA(), this.responseNumber, member, oldChannel));
            }
        }
        boolean wasMute = vState.isMuted();
        boolean wasDeaf = vState.isDeafened();
        if (selfMuted != vState.isSelfMuted()) {
            vState.setSelfMuted(selfMuted);
            this.getJDA().getEventManager().handle(new GuildVoiceSelfMuteEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
        if (selfDeafened != vState.isSelfDeafened()) {
            vState.setSelfDeafened(selfDeafened);
            this.getJDA().getEventManager().handle(new GuildVoiceSelfDeafenEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
        if (guildMuted != vState.isGuildMuted()) {
            vState.setGuildMuted(guildMuted);
            this.getJDA().getEventManager().handle(new GuildVoiceGuildMuteEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
        if (guildDeafened != vState.isGuildDeafened()) {
            vState.setGuildDeafened(guildDeafened);
            this.getJDA().getEventManager().handle(new GuildVoiceGuildDeafenEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
        if (suppressed != vState.isSuppressed()) {
            vState.setSuppressed(suppressed);
            this.getJDA().getEventManager().handle(new GuildVoiceSuppressEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
        if (wasMute != vState.isMuted()) {
            this.getJDA().getEventManager().handle(new GuildVoiceMuteEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
        if (wasDeaf != vState.isDeafened()) {
            this.getJDA().getEventManager().handle(new GuildVoiceDeafenEvent((JDA)this.getJDA(), this.responseNumber, member));
        }
    }

    private void handleCallVoiceState(JSONObject content) {
        CallVoiceStateImpl vState;
        long userId = content.getLong("user_id");
        Long channelId = content.isNull("channel_id") ? null : Long.valueOf(content.getLong("channel_id"));
        String sessionId = content.optString("session_id", null);
        boolean selfMuted = content.getBoolean("self_mute");
        boolean selfDeafened = content.getBoolean("self_deaf");
        if (channelId != null) {
            CallableChannel channel = this.getJDA().asClient().getGroupById(channelId);
            if (channel == null) {
                channel = this.getJDA().getPrivateChannelMap().get(channelId);
            }
            if (channel == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for a Group/PrivateChannel that was not yet cached! JSON: {}", (Object)content);
                return;
            }
            CallImpl call = (CallImpl)channel.getCurrentCall();
            if (call == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.CALL, channelId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for a Call that is not yet cached. JSON: {}", (Object)content);
                return;
            }
            CallUser cUser = this.getJDA().asClient().getCallUserMap().get(userId);
            if (cUser != null && channelId.longValue() != cUser.getCall().getCallableChannel().getIdLong()) {
                WebSocketClient.LOG.error("Received a VOICE_STATE_UPDATE for a user joining a call, but the user was already in a different call! Big error! JSON: {}", (Object)content);
                ((CallVoiceStateImpl)cUser.getVoiceState()).setInCall(false);
            }
            if ((cUser = call.getCallUserMap().get(userId)) == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.USER, userId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for a user that is not yet a a cached CallUser for the call. (groups only). JSON: {}", (Object)content);
                return;
            }
            this.getJDA().asClient().getCallUserMap().put(userId, cUser);
            vState = (CallVoiceStateImpl)cUser.getVoiceState();
            vState.setSessionId(sessionId);
            vState.setInCall(true);
            this.getJDA().getEventManager().handle(new CallVoiceJoinEvent((JDA)this.getJDA(), this.responseNumber, cUser));
        } else {
            CallUser cUser = this.getJDA().asClient().getCallUserMap().remove(userId);
            if (cUser == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.USER, userId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for a User leaving a Call, but the Call was not yet cached! JSON: {}", (Object)content);
                return;
            }
            Call call = cUser.getCall();
            CallableChannel channel = call.getCallableChannel();
            vState = (CallVoiceStateImpl)cUser.getVoiceState();
            vState.setSessionId(sessionId);
            vState.setInCall(false);
            this.getJDA().getEventManager().handle(new CallVoiceLeaveEvent((JDA)this.getJDA(), this.responseNumber, cUser));
        }
        if (selfMuted != vState.isSelfMuted()) {
            vState.setSelfMuted(selfMuted);
            this.getJDA().getEventManager().handle(new CallVoiceSelfMuteEvent((JDA)this.getJDA(), this.responseNumber, vState.getCallUser()));
        }
        if (selfDeafened != vState.isSelfDeafened()) {
            vState.setSelfDeafened(selfDeafened);
            this.getJDA().getEventManager().handle(new CallVoiceSelfDeafenEvent((JDA)this.getJDA(), this.responseNumber, vState.getCallUser()));
        }
    }
}

