/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.impl.FriendImpl;
import net.dv8tion.jda.client.entities.impl.UserSettingsImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReadyHandler
extends SocketHandler {
    public ReadyHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        JSONArray guilds = content.getJSONArray("guilds");
        JSONObject selfJson = content.getJSONObject("user");
        builder.createSelfUser(selfJson);
        if (this.getJDA().getAccountType() == AccountType.CLIENT && !content.isNull("user_settings")) {
            JSONObject userSettingsJson = content.getJSONObject("user_settings");
            UserSettingsImpl userSettingsObj = (UserSettingsImpl)this.getJDA().asClient().getSettings();
            userSettingsObj.setStatus(userSettingsJson.isNull("status") ? OnlineStatus.ONLINE : OnlineStatus.fromKey(userSettingsJson.getString("status")));
            if (userSettingsObj.getStatus() != OnlineStatus.ONLINE) {
                ((PresenceImpl)this.getJDA().getPresence()).setCacheStatus(userSettingsObj.getStatus());
            }
        }
        if (this.getJDA().getGuildSetupController().setIncompleteCount(guilds.length())) {
            for (int i = 0; i < guilds.length(); ++i) {
                JSONObject guild = guilds.getJSONObject(i);
                this.getJDA().getGuildSetupController().onReady(guild.getLong("id"), guild);
            }
        }
        this.handleReady(content);
        return null;
    }

    public void handleReady(JSONObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        JSONArray privateChannels = content.getJSONArray("private_channels");
        if (this.getJDA().getAccountType() == AccountType.CLIENT) {
            int i;
            JSONArray relationships = content.getJSONArray("relationships");
            JSONArray presences = content.getJSONArray("presences");
            for (i = 0; i < relationships.length(); ++i) {
                JSONObject relationship = relationships.getJSONObject(i);
                Relationship r = builder.createRelationship(relationship);
                if (r != null) continue;
                JDAImpl.LOG.warn("Provided relationship in READY with an unknown type! JSON: {}", (Object)relationship);
            }
            for (i = 0; i < presences.length(); ++i) {
                JSONObject presence = presences.getJSONObject(i);
                long userId = presence.getJSONObject("user").getLong("id");
                FriendImpl friend = (FriendImpl)this.getJDA().asClient().getFriendById(userId);
                if (friend == null) {
                    WebSocketClient.LOG.debug("Received a presence in the Presences array in READY that did not correspond to a cached Friend! JSON: {}", (Object)presence);
                    continue;
                }
                builder.createPresence(friend, presence);
            }
        }
        block6: for (int i = 0; i < privateChannels.length(); ++i) {
            JSONObject chan = privateChannels.getJSONObject(i);
            ChannelType type = ChannelType.fromId(chan.getInt("type"));
            switch (type) {
                case PRIVATE: {
                    builder.createPrivateChannel(chan);
                    continue block6;
                }
                case GROUP: {
                    builder.createGroup(chan);
                    continue block6;
                }
                default: {
                    WebSocketClient.LOG.warn("Received a Channel in the private_channels array in READY of an unknown type! JSON: {}", (Object)type);
                }
            }
        }
    }
}

