/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.audio;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import org.slf4j.MDC;

public class KeepAliveThreadFactory
implements ThreadFactory {
    final String identifier;
    final AtomicInteger threadCount = new AtomicInteger(1);
    final ConcurrentMap<String, String> contextMap;

    public KeepAliveThreadFactory(JDAImpl api) {
        this.contextMap = api.getContextMap();
        this.identifier = api.getIdentifierString() + " Audio-KeepAlive Pool";
    }

    @Override
    public Thread newThread(Runnable r) {
        Runnable r2 = () -> {
            if (this.contextMap != null) {
                this.contextMap.forEach(MDC::put);
            }
            r.run();
        };
        Thread t = new Thread(AudioManagerImpl.AUDIO_THREADS, r2, this.identifier + " - Thread " + this.threadCount.getAndIncrement());
        t.setDaemon(true);
        return t;
    }
}

