/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.bot.entities.impl;

import java.util.Collection;
import net.dv8tion.jda.bot.JDABot;
import net.dv8tion.jda.bot.entities.ApplicationInfo;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;

public class JDABotImpl
implements JDABot {
    protected final UpstreamReference<JDAImpl> api;
    protected String clientId = null;
    protected ShardManager shardManager = null;

    public JDABotImpl(JDAImpl api) {
        this.api = new UpstreamReference<JDAImpl>(api);
    }

    @Override
    public JDA getJDA() {
        return this.api.get();
    }

    @Override
    public RestAction<ApplicationInfo> getApplicationInfo() {
        Route.CompiledRoute route = Route.Applications.GET_BOT_APPLICATION.compile(new String[0]);
        return new RestAction<ApplicationInfo>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<ApplicationInfo> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                ApplicationInfo info = ((JDAImpl)this.api.get()).getEntityBuilder().createApplicationInfo(response.getObject());
                JDABotImpl.this.clientId = info.getId();
                request.onSuccess(info);
            }
        };
    }

    @Override
    public String getInviteUrl(Permission ... permissions) {
        StringBuilder builder = this.buildBaseInviteUrl();
        if (permissions != null && permissions.length > 0) {
            builder.append("&permissions=").append(Permission.getRaw(permissions));
        }
        return builder.toString();
    }

    @Override
    public String getInviteUrl(Collection<Permission> permissions) {
        StringBuilder builder = this.buildBaseInviteUrl();
        if (permissions != null && !permissions.isEmpty()) {
            builder.append("&permissions=").append(Permission.getRaw(permissions));
        }
        return builder.toString();
    }

    private StringBuilder buildBaseInviteUrl() {
        if (this.clientId == null) {
            this.getApplicationInfo().complete();
        }
        StringBuilder builder = new StringBuilder("https://discordapp.com/oauth2/authorize?scope=bot&client_id=");
        builder.append(this.clientId);
        return builder;
    }

    public void setShardManager(ShardManager shardManager) {
        this.shardManager = shardManager;
    }

    @Override
    public ShardManager getShardManager() {
        return this.shardManager;
    }
}

