/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimplePropertyExpression;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprRegionOfGuild
extends ChangeableSimplePropertyExpression<Guild, Region> {
    protected String getPropertyName() {
        return "region of";
    }

    public Region convert(Guild guild) {
        return guild.getRegion();
    }

    public Class<? extends Region> getReturnType() {
        return Region.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Region.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        for (Guild guild : (Guild[])this.getExpr().getAll(e)) {
            Guild bindedGuild = Util.bindGuild(bot, guild);
            if (bindedGuild == null) continue;
            try {
                bindedGuild.getManager().setRegion((Region)((Object)delta[0])).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "set region", x.getPermission().getName());
            }
        }
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprRegionOfGuild.class, Region.class, "region", "guilds").setName("Region of Guild").setDesc("Get the current region of a guild.").setExample("broadcast \"%region of event-guild%\"");
    }
}

