/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.changers;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Patterns;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableExpression;
import me.iblitzkriegi.vixio.changers.ChangeablePropertyExpression;
import me.iblitzkriegi.vixio.changers.ChangeableSimpleExpression;
import me.iblitzkriegi.vixio.changers.ChangeableSimplePropertyExpression;
import me.iblitzkriegi.vixio.changers.VixioChanger;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.skript.SkriptUtil;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EffChange
extends Effect {
    public static Bot currentBot;
    private static boolean parsing;
    private static Patterns<Changer.ChangeMode> patterns;
    private Expression<?> changed;
    @Nullable
    private Expression<?> changer = null;
    private Expression<Bot> bot;
    private Changer.ChangeMode mode;
    private boolean single;

    public static boolean isParsing(Expression<?> expression, boolean shouldError) {
        if (parsing) {
            return true;
        }
        if (shouldError) {
            Skript.error((String)((expression == null ? "This expression" : expression.toString(null, false)) + " can only be changed using Vixio's changer effects"));
        }
        return false;
    }

    public static String format(Changer.ChangeMode mode, String prop, Expression<?> changed, Bot bot) {
        return mode.name().toLowerCase(Locale.ENGLISH).replace("_", " ") + " " + prop + " " + changed.toString(null, false) + " with \"" + bot.toString() + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String what;
        Object[] rs;
        parsing = true;
        this.mode = (Changer.ChangeMode)patterns.getInfo(matchedPattern);
        switch (this.mode) {
            case ADD: {
                this.bot = exprs[2];
                if (matchedPattern == 0) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case SET: {
                this.bot = exprs[2];
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case REMOVE_ALL: {
                this.bot = exprs[2];
                this.changer = exprs[0];
                this.changed = exprs[1];
                break;
            }
            case REMOVE: {
                this.bot = exprs[2];
                if (matchedPattern == 5) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case DELETE: {
                this.bot = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case RESET: {
                this.bot = exprs[1];
                this.changed = exprs[0];
            }
        }
        this.bot = SkriptUtil.defaultToEventValue(this.bot, Bot.class);
        if (this.bot == null) {
            return false;
        }
        if (!(this.changed instanceof ChangeablePropertyExpression || this.changed instanceof ChangeableSimpleExpression || this.changed instanceof ChangeableSimplePropertyExpression || Classes.getSuperClassInfo((Class)this.changed.getReturnType()).getChanger() instanceof VixioChanger)) {
            if (!this.bot.isDefault()) {
                Skript.error((String)(this.changed.toString(null, false) + " can't be changed with Vixio's changer effects"));
            }
            parsing = false;
            return false;
        }
        CountingLogHandler h = (CountingLogHandler)SkriptLogger.startLogHandler((LogHandler)new CountingLogHandler(Level.SEVERE));
        try {
            rs = this.changed.acceptChange(this.mode);
            ClassInfo c = Classes.getSuperClassInfo((Class)this.changed.getReturnType());
            Changer changer = c.getChanger();
            what = changer == null || !Arrays.equals(changer.acceptChange(this.mode), rs) ? this.changed.toString(null, false) : c.getName().withIndefiniteArticle();
        }
        finally {
            h.stop();
        }
        if (rs == null) {
            if (h.getCount() > 0) {
                parsing = false;
                return false;
            }
            switch (this.mode) {
                case SET: {
                    Skript.error((String)(what + " can't be set to anything"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case DELETE: {
                    if (this.changed.acceptChange(Changer.ChangeMode.RESET) != null) {
                        Skript.error((String)(what + " can't be deleted/cleared. It can however be reset which might result in the desired effect."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                    Skript.error((String)(what + " can't be deleted/cleared"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case REMOVE_ALL: {
                    if (this.changed.acceptChange(Changer.ChangeMode.REMOVE) != null) {
                        Skript.error((String)(what + " can't have 'all of something' removed from it. Use 'remove' instead of 'remove all' to fix this."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                }
                case ADD: 
                case REMOVE: {
                    Skript.error((String)(what + " can't have anything " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " it"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case RESET: {
                    if (this.changed.acceptChange(Changer.ChangeMode.DELETE) != null) {
                        Skript.error((String)(what + " can't be reset. It can however be deleted which might result in the desired effect."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                    Skript.error((String)(what + " can't be reset"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                }
            }
            parsing = false;
            return false;
        }
        Object[] rs2 = new Class[rs.length];
        for (int i = 0; i < rs.length; ++i) {
            rs2[i] = ((Class)rs[i]).isArray() ? ((Class)rs[i]).getComponentType() : rs[i];
        }
        boolean allSingle = Arrays.equals(rs, rs2);
        Expression ch = this.changer;
        if (ch != null) {
            ClassInfo ci;
            int i;
            Expression v = null;
            ParseLogHandler log = SkriptLogger.startParseLogHandler();
            try {
                for (Class<?> clazz : rs) {
                    log.clear();
                    if (!(clazz.isArray() ? clazz.getComponentType() : clazz).isAssignableFrom(ch.getReturnType())) continue;
                    v = ch.getConvertedExpression(new Class[]{Object.class});
                    break;
                }
                if (v == null) {
                    v = ch.getConvertedExpression((Class[])rs2);
                }
                if (v == null) {
                    if (log.hasError()) {
                        log.printError();
                        parsing = false;
                        boolean bl = false;
                        return bl;
                    }
                    log.clear();
                    log.printLog();
                    Class[] r = new Class[rs.length];
                    for (i = 0; i < rs.length; i += 1) {
                        r[i] = ((Class)rs[i]).isArray() ? ((Class)rs[i]).getComponentType() : rs[i];
                    }
                    if (rs.length == 1 && rs[0] == Object.class) {
                        Skript.error((String)("Can't understand this expression: " + this.changer), (ErrorQuality)ErrorQuality.NOT_AN_EXPRESSION);
                    } else if (this.mode == Changer.ChangeMode.SET) {
                        Skript.error((String)(what + " can't be set to " + this.changer + " because the latter is " + SkriptParser.notOfType((Class[])r)), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    } else {
                        Skript.error((String)(this.changer + " can't be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + what + " because the former is " + SkriptParser.notOfType((Class[])r)), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    }
                    parsing = false;
                    i = 0;
                    return i != 0;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
            Object x = Utils.getSuperType((Class[])rs2);
            this.single = allSingle;
            for (i = 0; i < rs.length; i += 1) {
                if (!((Class)rs2[i]).isAssignableFrom(v.getReturnType())) continue;
                this.single = !((Class)rs[i]).isArray();
                x = rs2[i];
                break;
            }
            assert (x != null);
            this.changer = ch = v;
            if (!ch.isSingle() && this.single) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error((String)(this.changed + " can only be set to one " + Classes.getSuperClassInfo((Class)x).getName() + ", not more"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error((String)("only one " + Classes.getSuperClassInfo((Class)x).getName() + " can be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + ", not more"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                }
                parsing = false;
                return false;
            }
            if (this.changed instanceof Variable && !((Variable)this.changed).isLocal() && (this.mode == Changer.ChangeMode.SET || ((Variable)this.changed).isList() && this.mode == Changer.ChangeMode.ADD) && (ci = Classes.getSuperClassInfo((Class)ch.getReturnType())).getC() != Object.class && ci.getSerializer() == null && ci.getSerializeAs() == null && !((Boolean)SkriptConfig.disableObjectCannotBeSavedWarnings.value()).booleanValue()) {
                Skript.warning((String)(ci.getName().withIndefiniteArticle() + " cannot be saved, i.e. the contents of the variable " + this.changed + " will be lost when the server stops."));
            }
        }
        parsing = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Event e) {
        Expression<?> changer = this.changer;
        Object[] delta = changer == null ? null : changer.getArray(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (delta != null && delta.length == 0) {
            return;
        }
        if (bot == null) {
            Vixio.getErrorHandler().warn("Vixio tried to change \"" + this.changed.toString(e, false) + "\", but the bot wasn't found.");
            return;
        }
        try {
            currentBot = bot;
            if (this.changed instanceof ChangeableSimplePropertyExpression) {
                ((ChangeableSimplePropertyExpression)this.changed).change(e, delta, bot, this.mode);
            } else if (this.changed instanceof ChangeableSimpleExpression) {
                ((ChangeableSimpleExpression)this.changed).change(e, delta, bot, this.mode);
            } else if (this.changed instanceof ChangeablePropertyExpression) {
                ((ChangeablePropertyExpression)this.changed).change(e, delta, bot, this.mode);
            } else if (this.changed instanceof ChangeableExpression) {
                ((ChangeableExpression)this.changed).change(e, delta, bot, this.mode);
            } else {
                this.changed.change(e, delta, this.mode);
            }
        }
        finally {
            currentBot = null;
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        Expression<?> changer = this.changer;
        switch (this.mode) {
            case ADD: {
                assert (changer != null);
                return "add " + changer.toString(e, debug) + " to " + this.changed.toString(e, debug) + " with " + this.bot.toString(e, debug);
            }
            case SET: {
                assert (changer != null);
                return "set " + this.changed.toString(e, debug) + " to " + changer.toString(e, debug) + " with " + this.bot.toString(e, debug);
            }
            case REMOVE: {
                assert (changer != null);
                return "remove " + changer.toString(e, debug) + " from " + this.changed.toString(e, debug) + " with " + this.bot.toString(e, debug);
            }
            case REMOVE_ALL: {
                assert (changer != null);
                return "remove all " + changer.toString(e, debug) + " from " + this.changed.toString(e, debug) + " with " + this.bot.toString(e, debug);
            }
            case DELETE: {
                return "delete/clear " + this.changed.toString(e, debug) + " with " + this.bot.toString(e, debug);
            }
            case RESET: {
                return "reset " + this.changed.toString(e, debug) + " with " + this.bot.toString(e, debug);
            }
        }
        assert (false);
        return "";
    }

    static {
        patterns = new Patterns((Object[][])new Object[][]{{"(add|give) %objects% to (%~objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.ADD}, {"increase %~objects% by (%objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.ADD}, {"give %~objects% (%objects%) as %-bot/string%", Changer.ChangeMode.ADD}, {"set %~objects% to (%objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.SET}, {"remove (all|every) %objects% from (%~objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.REMOVE_ALL}, {"(remove|subtract) %objects% from (%~objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.REMOVE}, {"reduce %~objects% by (%objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.REMOVE}, {"(delete|clear) (%~objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.DELETE}, {"reset (%~objects%) [(with|using) %-bot/string%]", Changer.ChangeMode.RESET}});
        Skript.getInstance();
        Skript.registerEffect(EffChange.class, (String[])patterns.getPatterns());
    }
}

