/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.ThreadLocalHttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.TrustManagerBuilder;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import me.iblitzkriegi.vixio.org.apache.http.ConnectionClosedException;
import me.iblitzkriegi.vixio.org.apache.http.Header;
import me.iblitzkriegi.vixio.org.apache.http.HttpRequest;
import me.iblitzkriegi.vixio.org.apache.http.HttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.HttpResponseFactory;
import me.iblitzkriegi.vixio.org.apache.http.NoHttpResponseException;
import me.iblitzkriegi.vixio.org.apache.http.ProtocolException;
import me.iblitzkriegi.vixio.org.apache.http.ProtocolVersion;
import me.iblitzkriegi.vixio.org.apache.http.client.RedirectStrategy;
import me.iblitzkriegi.vixio.org.apache.http.client.config.RequestConfig;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpUriRequest;
import me.iblitzkriegi.vixio.org.apache.http.config.MessageConstraints;
import me.iblitzkriegi.vixio.org.apache.http.config.Registry;
import me.iblitzkriegi.vixio.org.apache.http.config.RegistryBuilder;
import me.iblitzkriegi.vixio.org.apache.http.conn.HttpClientConnectionManager;
import me.iblitzkriegi.vixio.org.apache.http.conn.socket.ConnectionSocketFactory;
import me.iblitzkriegi.vixio.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import me.iblitzkriegi.vixio.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import me.iblitzkriegi.vixio.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import me.iblitzkriegi.vixio.org.apache.http.conn.util.PublicSuffixMatcherLoader;
import me.iblitzkriegi.vixio.org.apache.http.impl.DefaultHttpResponseFactory;
import me.iblitzkriegi.vixio.org.apache.http.impl.client.BasicCookieStore;
import me.iblitzkriegi.vixio.org.apache.http.impl.client.CloseableHttpClient;
import me.iblitzkriegi.vixio.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import me.iblitzkriegi.vixio.org.apache.http.impl.client.HttpClientBuilder;
import me.iblitzkriegi.vixio.org.apache.http.impl.conn.DefaultHttpResponseParser;
import me.iblitzkriegi.vixio.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import me.iblitzkriegi.vixio.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import me.iblitzkriegi.vixio.org.apache.http.io.SessionInputBuffer;
import me.iblitzkriegi.vixio.org.apache.http.message.BasicLineParser;
import me.iblitzkriegi.vixio.org.apache.http.message.LineParser;
import me.iblitzkriegi.vixio.org.apache.http.message.ParserCursor;
import me.iblitzkriegi.vixio.org.apache.http.protocol.HttpContext;
import me.iblitzkriegi.vixio.org.apache.http.ssl.SSLContexts;
import me.iblitzkriegi.vixio.org.apache.http.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTools {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTools.class);
    private static final SSLContext defaultSslContext = HttpClientTools.setupSslContext();
    public static final RequestConfig DEFAULT_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(3000).setCookieSpec("standard").build();
    private static final RequestConfig NO_COOKIES_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(3000).setCookieSpec("ignoreCookies").build();

    public static HttpClientBuilder createSharedCookiesHttpBuilder() {
        return HttpClientTools.createHttpBuilder(DEFAULT_REQUEST_CONFIG);
    }

    public static HttpInterfaceManager createDefaultThreadLocalManager() {
        return new ThreadLocalHttpInterfaceManager(HttpClientTools.createSharedCookiesHttpBuilder(), DEFAULT_REQUEST_CONFIG);
    }

    public static HttpInterfaceManager createCookielessThreadLocalManager() {
        return new ThreadLocalHttpInterfaceManager(HttpClientTools.createHttpBuilder(NO_COOKIES_REQUEST_CONFIG), NO_COOKIES_REQUEST_CONFIG);
    }

    private static HttpClientBuilder createHttpBuilder(RequestConfig requestConfig) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        return new CustomHttpClientBuilder().setDefaultCookieStore(cookieStore).setRetryHandler(NoResponseRetryHandler.RETRY_INSTANCE).setDefaultRequestConfig(requestConfig);
    }

    private static SSLContext setupSslContext() {
        try {
            X509TrustManager trustManager = new TrustManagerBuilder().addBuiltinCertificates().addFromResourceDirectory("/certificates").build();
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{trustManager}, null);
            return context;
        }
        catch (Exception e) {
            log.error("Failed to build custom SSL context, using default one.", e);
            return SSLContexts.createDefault();
        }
    }

    public static String getRedirectLocation(String requestUrl, HttpResponse response) {
        if (!HttpClientTools.isRedirectStatus(response.getStatusLine().getStatusCode())) {
            return null;
        }
        Header header = response.getFirstHeader("Location");
        if (header == null) {
            return null;
        }
        String location = header.getValue();
        try {
            return new URI(requestUrl).resolve(location).toString();
        }
        catch (URISyntaxException e) {
            log.debug("Failed to parse URI.", e);
            return location;
        }
    }

    private static boolean isRedirectStatus(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSuccessWithContent(int statusCode) {
        return statusCode == 200 || statusCode == 206;
    }

    public static boolean isRetriableNetworkException(Throwable exception) {
        return HttpClientTools.isConnectionResetException(exception) || HttpClientTools.isSocketTimeoutException(exception) || HttpClientTools.isIncorrectSslShutdownException(exception) || HttpClientTools.isPrematureEndException(exception) || HttpClientTools.isRetriableConscryptException(exception);
    }

    private static boolean isConnectionResetException(Throwable exception) {
        return exception instanceof SocketException && "Connection reset".equals(exception.getMessage());
    }

    private static boolean isSocketTimeoutException(Throwable exception) {
        return exception instanceof SocketTimeoutException && "Read timed out".equals(exception.getMessage());
    }

    private static boolean isIncorrectSslShutdownException(Throwable exception) {
        return exception instanceof SSLException && "SSL peer shut down incorrectly".equals(exception.getMessage());
    }

    private static boolean isPrematureEndException(Throwable exception) {
        return exception instanceof ConnectionClosedException && exception.getMessage() != null && exception.getMessage().startsWith("Premature end of Content-Length");
    }

    private static boolean isRetriableConscryptException(Throwable exception) {
        String message;
        if (exception instanceof SSLException && (message = exception.getMessage()) != null && message.contains("I/O error during system call")) {
            return message.contains("No error") || message.contains("Connection reset by peer") || message.contains("Connection timed out");
        }
        return false;
    }

    public static JsonBrowser fetchResponseAsJson(HttpInterface httpInterface, HttpUriRequest request) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                JsonBrowser jsonBrowser = null;
                return jsonBrowser;
            }
            if (statusCode != 200) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code from channel info is " + statusCode));
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    public static String[] fetchResponseLines(HttpInterface httpInterface, HttpUriRequest request, String name) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Unexpected response code " + statusCode + " from " + name);
            }
            String[] stringArray = DataFormatTools.streamToLines(response.getEntity().getContent(), StandardCharsets.UTF_8);
            return stringArray;
        }
    }

    public static String getHeaderValue(HttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    private static class NoResponseRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private static final NoResponseRetryHandler RETRY_INSTANCE = new NoResponseRetryHandler();

        private NoResponseRetryHandler() {
        }

        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            boolean retry = super.retryRequest(exception, executionCount, context);
            if (!retry && exception instanceof NoHttpResponseException && executionCount < 5) {
                return true;
            }
            return retry;
        }
    }

    public static class NoRedirectsStrategy
    implements RedirectStrategy {
        @Override
        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        @Override
        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }

    public static class CustomHttpClientBuilder
    extends HttpClientBuilder {
        private SSLContext sslContextOverride;

        @Override
        public synchronized CloseableHttpClient build() {
            this.setConnectionManager(this.createConnectionManager());
            CloseableHttpClient httpClient = super.build();
            this.setConnectionManager(null);
            return httpClient;
        }

        public void setSslContextOverride(SSLContext sslContextOverride) {
            this.sslContextOverride = sslContextOverride;
        }

        private HttpClientConnectionManager createConnectionManager() {
            PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(this.createConnectionSocketFactory(), CustomHttpClientBuilder.createConnectionFactory());
            manager.setMaxTotal(3000);
            manager.setDefaultMaxPerRoute(1500);
            return manager;
        }

        private Registry<ConnectionSocketFactory> createConnectionSocketFactory() {
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(this.sslContextOverride != null ? this.sslContextOverride : defaultSslContext, (HostnameVerifier)hostnameVerifier);
            return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        }

        private static ManagedHttpClientConnectionFactory createConnectionFactory() {
            return new ManagedHttpClientConnectionFactory(null, (buffer, constraints) -> new GarbageAllergicHttpResponseParser(buffer, (LineParser)IcyHttpLineParser.ICY_INSTANCE, (HttpResponseFactory)DefaultHttpResponseFactory.INSTANCE, constraints));
        }
    }

    private static class IcyHttpLineParser
    extends BasicLineParser {
        private static final IcyHttpLineParser ICY_INSTANCE = new IcyHttpLineParser();
        private static final ProtocolVersion ICY_PROTOCOL = new ProtocolVersion("HTTP", 1, 0);

        private IcyHttpLineParser() {
        }

        @Override
        public ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
            int index = cursor.getPos();
            int bound = cursor.getUpperBound();
            if (bound >= index + 4 && "ICY ".equals(buffer.substring(index, index + 4))) {
                cursor.updatePos(index + 4);
                return ICY_PROTOCOL;
            }
            return super.parseProtocolVersion(buffer, cursor);
        }

        @Override
        public boolean hasProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
            int index = cursor.getPos();
            int bound = cursor.getUpperBound();
            if (bound >= index + 4 && "ICY ".equals(buffer.substring(index, index + 4))) {
                return true;
            }
            return super.hasProtocolVersion(buffer, cursor);
        }
    }

    private static class GarbageAllergicHttpResponseParser
    extends DefaultHttpResponseParser {
        public GarbageAllergicHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
            super(buffer, lineParser, responseFactory, constraints);
        }

        @Override
        protected boolean reject(CharArrayBuffer line, int count) {
            if (line.length() > 4 && "ICY ".equals(line.substring(0, 4))) {
                throw new FriendlyException("ICY protocol is not supported.", FriendlyException.Severity.COMMON, null);
            }
            if (count > 10) {
                throw new FriendlyException("The server is giving us garbage.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            return false;
        }
    }
}

