/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.beam;

import com.sedmelluq.discord.lavaplayer.source.stream.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamSegmentUrlProvider
extends M3uStreamSegmentUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(BeamSegmentUrlProvider.class);
    private final String channelId;
    private String streamSegmentPlaylistUrl;

    public BeamSegmentUrlProvider(String channelId) {
        this.channelId = channelId;
    }

    @Override
    protected String getQualityFromM3uDirective(ExtendedM3uParser.Line directiveLine) {
        return directiveLine.directiveArguments.get("NAME");
    }

    @Override
    protected String fetchSegmentPlaylistUrl(HttpInterface httpInterface) throws IOException {
        if (this.streamSegmentPlaylistUrl != null) {
            return this.streamSegmentPlaylistUrl;
        }
        HttpGet request = new HttpGet("https://beam.pro/api/v1/channels/" + this.channelId + "/manifest.m3u8");
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = this.loadChannelStreamsList(HttpClientTools.fetchResponseLines(httpInterface, request, "beam channel streams list"));
        if (streams.isEmpty()) {
            throw new IllegalStateException("No streams available on channel.");
        }
        M3uStreamSegmentUrlProvider.ChannelStreamInfo stream = streams.get(0);
        log.debug("Chose stream with quality {} from url {}", (Object)stream.quality, (Object)stream.url);
        this.streamSegmentPlaylistUrl = stream.url;
        return this.streamSegmentPlaylistUrl;
    }
}

