/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.remote;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.remote.AbandonedTrackManager;
import com.sedmelluq.discord.lavaplayer.remote.RemoteAudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNode;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeProcessor;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeRegistry;
import com.sedmelluq.discord.lavaplayer.tools.DaemonThreadFactory;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.ExecutorTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemoteNodeManager
extends AudioEventAdapter
implements RemoteNodeRegistry,
Runnable {
    private final DefaultAudioPlayerManager playerManager;
    private final HttpInterfaceManager httpInterfaceManager;
    private final List<RemoteNodeProcessor> processors;
    private final AbandonedTrackManager abandonedTrackManager;
    private final AtomicBoolean enabled;
    private final Object lock;
    private volatile ScheduledThreadPoolExecutor scheduler;
    private volatile List<RemoteNodeProcessor> activeProcessors;

    public RemoteNodeManager(DefaultAudioPlayerManager playerManager) {
        this.playerManager = playerManager;
        this.httpInterfaceManager = RemoteNodeProcessor.createHttpInterfaceManager();
        this.processors = new ArrayList<RemoteNodeProcessor>();
        this.abandonedTrackManager = new AbandonedTrackManager();
        this.enabled = new AtomicBoolean();
        this.lock = new Object();
        this.activeProcessors = new ArrayList<RemoteNodeProcessor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise(List<String> nodeAddresses) {
        Object object = this.lock;
        synchronized (object) {
            if (this.enabled.compareAndSet(false, true)) {
                this.startScheduler(nodeAddresses.size() + 1);
            } else {
                this.scheduler.setCorePoolSize(nodeAddresses.size() + 1);
            }
            ArrayList<String> newNodeAddresses = new ArrayList<String>(nodeAddresses);
            Iterator<RemoteNodeProcessor> iterator = this.processors.iterator();
            while (iterator.hasNext()) {
                RemoteNodeProcessor processor = iterator.next();
                if (newNodeAddresses.remove(processor.getAddress())) continue;
                processor.shutdown();
                iterator.remove();
            }
            for (String nodeAddress : newNodeAddresses) {
                RemoteNodeProcessor processor = new RemoteNodeProcessor(this.playerManager, nodeAddress, this.scheduler, this.httpInterfaceManager, this.abandonedTrackManager);
                this.scheduler.submit(processor);
                this.processors.add(processor);
            }
            this.activeProcessors = new ArrayList<RemoteNodeProcessor>(this.processors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean terminal) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.enabled.compareAndSet(true, false)) {
                return;
            }
            ExecutorTools.shutdownExecutor(this.scheduler, "node manager");
            for (RemoteNodeProcessor processor : this.processors) {
                processor.processHealthCheck(true);
            }
            this.abandonedTrackManager.shutdown();
            this.processors.clear();
            this.activeProcessors = new ArrayList<RemoteNodeProcessor>(this.processors);
        }
        if (terminal) {
            ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void startPlaying(RemoteAudioTrackExecutor remoteExecutor) {
        RemoteNodeProcessor processor = this.getNodeForNextTrack();
        processor.startPlaying(remoteExecutor);
    }

    private void startScheduler(int initialSize) {
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(initialSize, new DaemonThreadFactory("remote"));
        scheduledExecutor.scheduleAtFixedRate(this, 2000L, 2000L, TimeUnit.MILLISECONDS);
        this.scheduler = scheduledExecutor;
    }

    private RemoteNodeProcessor getNodeForNextTrack() {
        int lowestPenalty = Integer.MAX_VALUE;
        RemoteNodeProcessor node = null;
        for (RemoteNodeProcessor processor : this.processors) {
            int penalty = processor.getBalancerPenalty();
            if (penalty >= lowestPenalty) continue;
            lowestPenalty = penalty;
            node = processor;
        }
        if (node == null) {
            throw new FriendlyException("No available machines for playing track.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return node;
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        AudioTrackExecutor executor = ((InternalAudioTrack)track).getActiveExecutor();
        if (endReason != AudioTrackEndReason.FINISHED && executor instanceof RemoteAudioTrackExecutor) {
            for (RemoteNodeProcessor processor : this.activeProcessors) {
                processor.trackEnded((RemoteAudioTrackExecutor)executor, true);
            }
        }
    }

    @Override
    public void run() {
        for (RemoteNodeProcessor processor : this.activeProcessors) {
            processor.processHealthCheck(false);
        }
        this.abandonedTrackManager.drainExpired();
    }

    @Override
    public RemoteNode getNodeUsedForTrack(AudioTrack track) {
        for (RemoteNodeProcessor processor : this.activeProcessors) {
            if (!processor.isPlayingTrack(track)) continue;
            return processor;
        }
        return null;
    }

    @Override
    public List<RemoteNode> getNodes() {
        return new ArrayList<RemoteNode>(this.activeProcessors);
    }
}

