/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.opus;

import com.sedmelluq.discord.lavaplayer.natives.NativeResourceHolder;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusDecoderLibrary;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class OpusDecoder
extends NativeResourceHolder {
    private final OpusDecoderLibrary library = OpusDecoderLibrary.getInstance();
    private final long instance;
    private final int channels;

    public OpusDecoder(int sampleRate, int channels) {
        this.instance = this.library.create(sampleRate, channels);
        this.channels = channels;
        if (this.instance == 0L) {
            throw new IllegalStateException("Failed to create a decoder instance with sample rate " + sampleRate + " and channel count " + channels);
        }
    }

    public int decode(ByteBuffer directInput, ShortBuffer directOutput) {
        this.checkNotReleased();
        if (!directInput.isDirect() || !directOutput.isDirect()) {
            throw new IllegalArgumentException("Arguments must be direct buffers.");
        }
        directOutput.clear();
        int result = this.library.decode(this.instance, directInput, directInput.remaining(), directOutput, directOutput.remaining() / this.channels);
        if (result < 0) {
            throw new IllegalStateException("Decoding failed with error " + result);
        }
        directOutput.position(result * this.channels);
        directOutput.flip();
        return result;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }

    public static int getPacketFrameSize(int sampleRate, byte[] buffer, int offset, int length) {
        if (length < 1) {
            return 0;
        }
        int frameCount = OpusDecoder.getPacketFrameCount(buffer, offset, length);
        if (frameCount < 0) {
            return 0;
        }
        int samples = frameCount * OpusDecoder.getPacketSamplesPerFrame(sampleRate, buffer[offset]);
        if (samples * 25 > sampleRate * 3) {
            return 0;
        }
        return samples;
    }

    private static int getPacketFrameCount(byte[] buffer, int offset, int length) {
        switch (buffer[offset] & 3) {
            case 0: {
                return 1;
            }
            case 3: {
                return length < 2 ? -1 : buffer[offset + 1] & 0x3F;
            }
        }
        return 2;
    }

    private static int getPacketSamplesPerFrame(int frequency, int firstByte) {
        int shiftBits = firstByte >> 3 & 3;
        if ((firstByte & 0x80) != 0) {
            return (frequency << shiftBits) / 400;
        }
        if ((firstByte & 0x60) == 96) {
            return (firstByte & 8) != 0 ? frequency / 50 : frequency / 100;
        }
        if (shiftBits == 3) {
            return frequency * 60 / 1000;
        }
        return (frequency << shiftBits) / 100;
    }
}

