/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggFlacTrackProviderLoader;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggOpusTrackProviderLoader;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackProvider;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggVorbisTrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OggTrackLoader {
    private static final int FLAC_IDENTIFIER = ByteBuffer.wrap(new byte[]{127, 70, 76, 65}).getInt();
    private static final int VORBIS_IDENTIFIER = ByteBuffer.wrap(new byte[]{1, 118, 111, 114}).getInt();
    private static final int OPUS_IDENTIFIER = ByteBuffer.wrap(new byte[]{79, 112, 117, 115}).getInt();

    public static OggTrackProvider loadTrack(OggPacketInputStream packetInputStream) throws IOException {
        if (!packetInputStream.startNewTrack() || !packetInputStream.startNewPacket()) {
            return null;
        }
        DirectBufferStreamBroker broker = new DirectBufferStreamBroker(1024);
        broker.consume(true, packetInputStream);
        int headerIdentifier = broker.getBuffer().getInt();
        return OggTrackLoader.chooseTrackFromIdentifier(headerIdentifier, packetInputStream, broker);
    }

    private static OggTrackProvider chooseTrackFromIdentifier(int headerIdentifier, OggPacketInputStream packetInputStream, DirectBufferStreamBroker broker) throws IOException {
        if (headerIdentifier == FLAC_IDENTIFIER) {
            return OggFlacTrackProviderLoader.load(packetInputStream, broker);
        }
        if (headerIdentifier == VORBIS_IDENTIFIER) {
            return new OggVorbisTrackProvider(packetInputStream, broker);
        }
        if (headerIdentifier == OPUS_IDENTIFIER) {
            return OggOpusTrackProviderLoader.load(packetInputStream, broker);
        }
        throw new IllegalStateException("Unsupported track in OGG stream.");
    }
}

