/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.common.OpusPacketRouter;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class OggOpusTrackProvider
implements OggTrackProvider {
    private static final int OPUS_TAG_HALF = ByteBuffer.wrap(new byte[]{79, 112, 117, 115}).getInt();
    private static final int TAGS_TAG_HALF = ByteBuffer.wrap(new byte[]{84, 97, 103, 115}).getInt();
    private final OggPacketInputStream packetInputStream;
    private final DirectBufferStreamBroker broker;
    private final int channelCount;
    private final int sampleRate;
    private OpusPacketRouter opusPacketRouter;
    private ByteBuffer tagBuffer;

    public OggOpusTrackProvider(OggPacketInputStream packetInputStream, DirectBufferStreamBroker broker, int channelCount, int sampleRate, ByteBuffer tagBuffer) {
        this.packetInputStream = packetInputStream;
        this.broker = broker;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.tagBuffer = tagBuffer;
    }

    @Override
    public void initialise(AudioProcessingContext context) throws IOException {
        this.opusPacketRouter = new OpusPacketRouter(context, this.sampleRate, this.channelCount);
    }

    @Override
    public OggMetadata getMetadata() {
        if (this.tagBuffer.getInt() != OPUS_TAG_HALF || this.tagBuffer.getInt() != TAGS_TAG_HALF) {
            return OggMetadata.EMPTY;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        int vendorLength = Integer.reverseBytes(this.tagBuffer.getInt());
        this.tagBuffer.position(this.tagBuffer.position() + vendorLength);
        int itemCount = Integer.reverseBytes(this.tagBuffer.getInt());
        block0: for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            int itemLength = Integer.reverseBytes(this.tagBuffer.getInt());
            byte[] data = new byte[itemLength];
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 61) continue;
                tags.put(new String(data, 0, i, StandardCharsets.UTF_8), new String(data, i, data.length - i, StandardCharsets.UTF_8));
                continue block0;
            }
        }
        return new OggMetadata(tags);
    }

    @Override
    public OggStreamSizeInfo seekForSizeInfo() throws IOException {
        return this.packetInputStream.seekForSizeInfo(this.sampleRate);
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try {
            while (this.packetInputStream.startNewPacket()) {
                this.broker.consume(true, this.packetInputStream);
                ByteBuffer buffer = this.broker.getBuffer();
                if (buffer.remaining() <= 0) continue;
                this.opusPacketRouter.process(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToTimecode(long timecode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.opusPacketRouter != null) {
            this.opusPacketRouter.close();
        }
    }
}

